/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConnectorOperationType {
    UPDATE_WORKER_SETTING("UPDATE_WORKER_SETTING"),
    UPDATE_CONNECTOR_CONFIGURATION("UPDATE_CONNECTOR_CONFIGURATION"),
    ISOLATE_CONNECTOR("ISOLATE_CONNECTOR"),
    RESTORE_CONNECTOR("RESTORE_CONNECTOR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConnectorOperationType> VALUE_MAP;
    private final String value;

    private ConnectorOperationType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConnectorOperationType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConnectorOperationType> knownValues() {
        EnumSet<ConnectorOperationType> knownValues = EnumSet.allOf(ConnectorOperationType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConnectorOperationType.class, ConnectorOperationType::toString);
    }
}

