/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafkaconnect.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationState;
import software.amazon.awssdk.services.kafkaconnect.model.ConnectorOperationType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConnectorOperationSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConnectorOperationSummary> {
    private static final SdkField<String> CONNECTOR_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOperationArn").getter(ConnectorOperationSummary.getter(ConnectorOperationSummary::connectorOperationArn)).setter(ConnectorOperationSummary.setter(Builder::connectorOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationArn").build()}).build();
    private static final SdkField<String> CONNECTOR_OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOperationType").getter(ConnectorOperationSummary.getter(ConnectorOperationSummary::connectorOperationTypeAsString)).setter(ConnectorOperationSummary.setter(Builder::connectorOperationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationType").build()}).build();
    private static final SdkField<String> CONNECTOR_OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorOperationState").getter(ConnectorOperationSummary.getter(ConnectorOperationSummary::connectorOperationStateAsString)).setter(ConnectorOperationSummary.setter(Builder::connectorOperationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorOperationState").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("creationTime").getter(ConnectorOperationSummary.getter(ConnectorOperationSummary::creationTime)).setter(ConnectorOperationSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("endTime").getter(ConnectorOperationSummary.getter(ConnectorOperationSummary::endTime)).setter(ConnectorOperationSummary.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_OPERATION_ARN_FIELD, CONNECTOR_OPERATION_TYPE_FIELD, CONNECTOR_OPERATION_STATE_FIELD, CREATION_TIME_FIELD, END_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ConnectorOperationSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectorOperationArn;
    private final String connectorOperationType;
    private final String connectorOperationState;
    private final Instant creationTime;
    private final Instant endTime;

    private ConnectorOperationSummary(BuilderImpl builder) {
        this.connectorOperationArn = builder.connectorOperationArn;
        this.connectorOperationType = builder.connectorOperationType;
        this.connectorOperationState = builder.connectorOperationState;
        this.creationTime = builder.creationTime;
        this.endTime = builder.endTime;
    }

    public final String connectorOperationArn() {
        return this.connectorOperationArn;
    }

    public final ConnectorOperationType connectorOperationType() {
        return ConnectorOperationType.fromValue(this.connectorOperationType);
    }

    public final String connectorOperationTypeAsString() {
        return this.connectorOperationType;
    }

    public final ConnectorOperationState connectorOperationState() {
        return ConnectorOperationState.fromValue(this.connectorOperationState);
    }

    public final String connectorOperationStateAsString() {
        return this.connectorOperationState;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorOperationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectorOperationSummary)) {
            return false;
        }
        ConnectorOperationSummary other = (ConnectorOperationSummary)obj;
        return Objects.equals(this.connectorOperationArn(), other.connectorOperationArn()) && Objects.equals(this.connectorOperationTypeAsString(), other.connectorOperationTypeAsString()) && Objects.equals(this.connectorOperationStateAsString(), other.connectorOperationStateAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.endTime(), other.endTime());
    }

    public final String toString() {
        return ToString.builder((String)"ConnectorOperationSummary").add("ConnectorOperationArn", (Object)this.connectorOperationArn()).add("ConnectorOperationType", (Object)this.connectorOperationTypeAsString()).add("ConnectorOperationState", (Object)this.connectorOperationStateAsString()).add("CreationTime", (Object)this.creationTime()).add("EndTime", (Object)this.endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorOperationArn": {
                return Optional.ofNullable(clazz.cast(this.connectorOperationArn()));
            }
            case "connectorOperationType": {
                return Optional.ofNullable(clazz.cast(this.connectorOperationTypeAsString()));
            }
            case "connectorOperationState": {
                return Optional.ofNullable(clazz.cast(this.connectorOperationStateAsString()));
            }
            case "creationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "endTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorOperationArn", CONNECTOR_OPERATION_ARN_FIELD);
        map.put("connectorOperationType", CONNECTOR_OPERATION_TYPE_FIELD);
        map.put("connectorOperationState", CONNECTOR_OPERATION_STATE_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConnectorOperationSummary, T> g) {
        return obj -> g.apply((ConnectorOperationSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorOperationArn;
        private String connectorOperationType;
        private String connectorOperationState;
        private Instant creationTime;
        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ConnectorOperationSummary model) {
            this.connectorOperationArn(model.connectorOperationArn);
            this.connectorOperationType(model.connectorOperationType);
            this.connectorOperationState(model.connectorOperationState);
            this.creationTime(model.creationTime);
            this.endTime(model.endTime);
        }

        public final String getConnectorOperationArn() {
            return this.connectorOperationArn;
        }

        public final void setConnectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
        }

        @Override
        public final Builder connectorOperationArn(String connectorOperationArn) {
            this.connectorOperationArn = connectorOperationArn;
            return this;
        }

        public final String getConnectorOperationType() {
            return this.connectorOperationType;
        }

        public final void setConnectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
        }

        @Override
        public final Builder connectorOperationType(String connectorOperationType) {
            this.connectorOperationType = connectorOperationType;
            return this;
        }

        @Override
        public final Builder connectorOperationType(ConnectorOperationType connectorOperationType) {
            this.connectorOperationType(connectorOperationType == null ? null : connectorOperationType.toString());
            return this;
        }

        public final String getConnectorOperationState() {
            return this.connectorOperationState;
        }

        public final void setConnectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
        }

        @Override
        public final Builder connectorOperationState(String connectorOperationState) {
            this.connectorOperationState = connectorOperationState;
            return this;
        }

        @Override
        public final Builder connectorOperationState(ConnectorOperationState connectorOperationState) {
            this.connectorOperationState(connectorOperationState == null ? null : connectorOperationState.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public ConnectorOperationSummary build() {
            return new ConnectorOperationSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConnectorOperationSummary> {
        public Builder connectorOperationArn(String var1);

        public Builder connectorOperationType(String var1);

        public Builder connectorOperationType(ConnectorOperationType var1);

        public Builder connectorOperationState(String var1);

        public Builder connectorOperationState(ConnectorOperationState var1);

        public Builder creationTime(Instant var1);

        public Builder endTime(Instant var1);
    }
}

