/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.KafkaResponse;
import software.amazon.awssdk.services.kafka.model.TopicState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeTopicResponse
extends KafkaResponse
implements ToCopyableBuilder<Builder, DescribeTopicResponse> {
    private static final SdkField<String> TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicArn").getter(DescribeTopicResponse.getter(DescribeTopicResponse::topicArn)).setter(DescribeTopicResponse.setter(Builder::topicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicArn").build()}).build();
    private static final SdkField<String> TOPIC_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TopicName").getter(DescribeTopicResponse.getter(DescribeTopicResponse::topicName)).setter(DescribeTopicResponse.setter(Builder::topicName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("topicName").build()}).build();
    private static final SdkField<Integer> REPLICATION_FACTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ReplicationFactor").getter(DescribeTopicResponse.getter(DescribeTopicResponse::replicationFactor)).setter(DescribeTopicResponse.setter(Builder::replicationFactor)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationFactor").build()}).build();
    private static final SdkField<Integer> PARTITION_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PartitionCount").getter(DescribeTopicResponse.getter(DescribeTopicResponse::partitionCount)).setter(DescribeTopicResponse.setter(Builder::partitionCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partitionCount").build()}).build();
    private static final SdkField<String> CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Configs").getter(DescribeTopicResponse.getter(DescribeTopicResponse::configs)).setter(DescribeTopicResponse.setter(Builder::configs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configs").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeTopicResponse.getter(DescribeTopicResponse::statusAsString)).setter(DescribeTopicResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOPIC_ARN_FIELD, TOPIC_NAME_FIELD, REPLICATION_FACTOR_FIELD, PARTITION_COUNT_FIELD, CONFIGS_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeTopicResponse.memberNameToFieldInitializer();
    private final String topicArn;
    private final String topicName;
    private final Integer replicationFactor;
    private final Integer partitionCount;
    private final String configs;
    private final String status;

    private DescribeTopicResponse(BuilderImpl builder) {
        super(builder);
        this.topicArn = builder.topicArn;
        this.topicName = builder.topicName;
        this.replicationFactor = builder.replicationFactor;
        this.partitionCount = builder.partitionCount;
        this.configs = builder.configs;
        this.status = builder.status;
    }

    public final String topicArn() {
        return this.topicArn;
    }

    public final String topicName() {
        return this.topicName;
    }

    public final Integer replicationFactor() {
        return this.replicationFactor;
    }

    public final Integer partitionCount() {
        return this.partitionCount;
    }

    public final String configs() {
        return this.configs;
    }

    public final TopicState status() {
        return TopicState.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.topicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.topicName());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationFactor());
        hashCode = 31 * hashCode + Objects.hashCode(this.partitionCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.configs());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeTopicResponse)) {
            return false;
        }
        DescribeTopicResponse other = (DescribeTopicResponse)((Object)obj);
        return Objects.equals(this.topicArn(), other.topicArn()) && Objects.equals(this.topicName(), other.topicName()) && Objects.equals(this.replicationFactor(), other.replicationFactor()) && Objects.equals(this.partitionCount(), other.partitionCount()) && Objects.equals(this.configs(), other.configs()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeTopicResponse").add("TopicArn", (Object)this.topicArn()).add("TopicName", (Object)this.topicName()).add("ReplicationFactor", (Object)this.replicationFactor()).add("PartitionCount", (Object)this.partitionCount()).add("Configs", (Object)this.configs()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TopicArn": {
                return Optional.ofNullable(clazz.cast(this.topicArn()));
            }
            case "TopicName": {
                return Optional.ofNullable(clazz.cast(this.topicName()));
            }
            case "ReplicationFactor": {
                return Optional.ofNullable(clazz.cast(this.replicationFactor()));
            }
            case "PartitionCount": {
                return Optional.ofNullable(clazz.cast(this.partitionCount()));
            }
            case "Configs": {
                return Optional.ofNullable(clazz.cast(this.configs()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("topicArn", TOPIC_ARN_FIELD);
        map.put("topicName", TOPIC_NAME_FIELD);
        map.put("replicationFactor", REPLICATION_FACTOR_FIELD);
        map.put("partitionCount", PARTITION_COUNT_FIELD);
        map.put("configs", CONFIGS_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeTopicResponse, T> g) {
        return obj -> g.apply((DescribeTopicResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends KafkaResponse.BuilderImpl
    implements Builder {
        private String topicArn;
        private String topicName;
        private Integer replicationFactor;
        private Integer partitionCount;
        private String configs;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeTopicResponse model) {
            super(model);
            this.topicArn(model.topicArn);
            this.topicName(model.topicName);
            this.replicationFactor(model.replicationFactor);
            this.partitionCount(model.partitionCount);
            this.configs(model.configs);
            this.status(model.status);
        }

        public final String getTopicArn() {
            return this.topicArn;
        }

        public final void setTopicArn(String topicArn) {
            this.topicArn = topicArn;
        }

        @Override
        public final Builder topicArn(String topicArn) {
            this.topicArn = topicArn;
            return this;
        }

        public final String getTopicName() {
            return this.topicName;
        }

        public final void setTopicName(String topicName) {
            this.topicName = topicName;
        }

        @Override
        public final Builder topicName(String topicName) {
            this.topicName = topicName;
            return this;
        }

        public final Integer getReplicationFactor() {
            return this.replicationFactor;
        }

        public final void setReplicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
        }

        @Override
        public final Builder replicationFactor(Integer replicationFactor) {
            this.replicationFactor = replicationFactor;
            return this;
        }

        public final Integer getPartitionCount() {
            return this.partitionCount;
        }

        public final void setPartitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
        }

        @Override
        public final Builder partitionCount(Integer partitionCount) {
            this.partitionCount = partitionCount;
            return this;
        }

        public final String getConfigs() {
            return this.configs;
        }

        public final void setConfigs(String configs) {
            this.configs = configs;
        }

        @Override
        public final Builder configs(String configs) {
            this.configs = configs;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(TopicState status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DescribeTopicResponse build() {
            return new DescribeTopicResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends KafkaResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeTopicResponse> {
        public Builder topicArn(String var1);

        public Builder topicName(String var1);

        public Builder replicationFactor(Integer var1);

        public Builder partitionCount(Integer var1);

        public Builder configs(String var1);

        public Builder status(String var1);

        public Builder status(TopicState var1);
    }
}

