/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.Configuration;
import software.amazon.awssdk.services.kafka.model.ListConfigurationsRequest;
import software.amazon.awssdk.services.kafka.model.ListConfigurationsResponse;

public class ListConfigurationsPublisher
implements SdkPublisher<ListConfigurationsResponse> {
    private final KafkaAsyncClient client;
    private final ListConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListConfigurationsPublisher(KafkaAsyncClient client, ListConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListConfigurationsPublisher(KafkaAsyncClient client, ListConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Configuration> configurations() {
        return this.flatMapIterable(response -> response.configurations());
    }

    private class ListConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListConfigurationsResponse> {
        private ListConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListConfigurationsResponse> nextPage(ListConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListConfigurationsPublisher.this.client.listConfigurations(ListConfigurationsPublisher.this.firstRequest);
            }
            return ListConfigurationsPublisher.this.client.listConfigurations((ListConfigurationsRequest)((Object)ListConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

