/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.kafka.KafkaAsyncClient;
import software.amazon.awssdk.services.kafka.internal.UserAgentUtils;
import software.amazon.awssdk.services.kafka.model.ListTopicsRequest;
import software.amazon.awssdk.services.kafka.model.ListTopicsResponse;
import software.amazon.awssdk.services.kafka.model.TopicInfo;

public class ListTopicsPublisher
implements SdkPublisher<ListTopicsResponse> {
    private final KafkaAsyncClient client;
    private final ListTopicsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTopicsPublisher(KafkaAsyncClient client, ListTopicsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTopicsPublisher(KafkaAsyncClient client, ListTopicsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTopicsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTopicsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TopicInfo> topics() {
        Function<ListTopicsResponse, Iterator> getIterator = response -> {
            if (response != null && response.topics() != null) {
                return response.topics().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTopicsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTopicsResponseFetcher
    implements AsyncPageFetcher<ListTopicsResponse> {
        private ListTopicsResponseFetcher() {
        }

        public boolean hasNextPage(ListTopicsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTopicsResponse> nextPage(ListTopicsResponse previousPage) {
            if (previousPage == null) {
                return ListTopicsPublisher.this.client.listTopics(ListTopicsPublisher.this.firstRequest);
            }
            return ListTopicsPublisher.this.client.listTopics((ListTopicsRequest)((Object)ListTopicsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

