/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.kafka.model.BrokerNodeGroupInfo;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.ClientAuthentication;
import software.amazon.awssdk.services.kafka.model.ClusterState;
import software.amazon.awssdk.services.kafka.model.CustomerActionStatus;
import software.amazon.awssdk.services.kafka.model.EncryptionInfo;
import software.amazon.awssdk.services.kafka.model.EnhancedMonitoring;
import software.amazon.awssdk.services.kafka.model.LoggingInfo;
import software.amazon.awssdk.services.kafka.model.OpenMonitoring;
import software.amazon.awssdk.services.kafka.model.Rebalancing;
import software.amazon.awssdk.services.kafka.model.StateInfo;
import software.amazon.awssdk.services.kafka.model.StorageMode;
import software.amazon.awssdk.services.kafka.model.___mapOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInfo> {
    private static final SdkField<String> ACTIVE_OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ActiveOperationArn").getter(ClusterInfo.getter(ClusterInfo::activeOperationArn)).setter(ClusterInfo.setter(Builder::activeOperationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeOperationArn").build()}).build();
    private static final SdkField<BrokerNodeGroupInfo> BROKER_NODE_GROUP_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BrokerNodeGroupInfo").getter(ClusterInfo.getter(ClusterInfo::brokerNodeGroupInfo)).setter(ClusterInfo.setter(Builder::brokerNodeGroupInfo)).constructor(BrokerNodeGroupInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerNodeGroupInfo").build()}).build();
    private static final SdkField<Rebalancing> REBALANCING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Rebalancing").getter(ClusterInfo.getter(ClusterInfo::rebalancing)).setter(ClusterInfo.setter(Builder::rebalancing)).constructor(Rebalancing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rebalancing").build()}).build();
    private static final SdkField<ClientAuthentication> CLIENT_AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClientAuthentication").getter(ClusterInfo.getter(ClusterInfo::clientAuthentication)).setter(ClusterInfo.setter(Builder::clientAuthentication)).constructor(ClientAuthentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientAuthentication").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterInfo.getter(ClusterInfo::clusterArn)).setter(ClusterInfo.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(ClusterInfo.getter(ClusterInfo::clusterName)).setter(ClusterInfo.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ClusterInfo.getter(ClusterInfo::creationTime)).setter(ClusterInfo.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("creationTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo").getter(ClusterInfo.getter(ClusterInfo::currentBrokerSoftwareInfo)).setter(ClusterInfo.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<String> CURRENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CurrentVersion").getter(ClusterInfo.getter(ClusterInfo::currentVersion)).setter(ClusterInfo.setter(Builder::currentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentVersion").build()}).build();
    private static final SdkField<EncryptionInfo> ENCRYPTION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EncryptionInfo").getter(ClusterInfo.getter(ClusterInfo::encryptionInfo)).setter(ClusterInfo.setter(Builder::encryptionInfo)).constructor(EncryptionInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionInfo").build()}).build();
    private static final SdkField<String> ENHANCED_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnhancedMonitoring").getter(ClusterInfo.getter(ClusterInfo::enhancedMonitoringAsString)).setter(ClusterInfo.setter(Builder::enhancedMonitoring)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enhancedMonitoring").build()}).build();
    private static final SdkField<OpenMonitoring> OPEN_MONITORING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OpenMonitoring").getter(ClusterInfo.getter(ClusterInfo::openMonitoring)).setter(ClusterInfo.setter(Builder::openMonitoring)).constructor(OpenMonitoring::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openMonitoring").build()}).build();
    private static final SdkField<LoggingInfo> LOGGING_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LoggingInfo").getter(ClusterInfo.getter(ClusterInfo::loggingInfo)).setter(ClusterInfo.setter(Builder::loggingInfo)).constructor(LoggingInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("loggingInfo").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_BROKER_NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfBrokerNodes").getter(ClusterInfo.getter(ClusterInfo::numberOfBrokerNodes)).setter(ClusterInfo.setter(Builder::numberOfBrokerNodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfBrokerNodes").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ClusterInfo.getter(ClusterInfo::stateAsString)).setter(ClusterInfo.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final SdkField<StateInfo> STATE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StateInfo").getter(ClusterInfo.getter(ClusterInfo::stateInfo)).setter(ClusterInfo.setter(Builder::stateInfo)).constructor(StateInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stateInfo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Tags").getter(ClusterInfo.getter(ClusterInfo::tags)).setter(ClusterInfo.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectString").getter(ClusterInfo.getter(ClusterInfo::zookeeperConnectString)).setter(ClusterInfo.setter(Builder::zookeeperConnectString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectString").build()}).build();
    private static final SdkField<String> ZOOKEEPER_CONNECT_STRING_TLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ZookeeperConnectStringTls").getter(ClusterInfo.getter(ClusterInfo::zookeeperConnectStringTls)).setter(ClusterInfo.setter(Builder::zookeeperConnectStringTls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("zookeeperConnectStringTls").build()}).build();
    private static final SdkField<String> STORAGE_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageMode").getter(ClusterInfo.getter(ClusterInfo::storageModeAsString)).setter(ClusterInfo.setter(Builder::storageMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageMode").build()}).build();
    private static final SdkField<String> CUSTOMER_ACTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomerActionStatus").getter(ClusterInfo.getter(ClusterInfo::customerActionStatusAsString)).setter(ClusterInfo.setter(Builder::customerActionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerActionStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTIVE_OPERATION_ARN_FIELD, BROKER_NODE_GROUP_INFO_FIELD, REBALANCING_FIELD, CLIENT_AUTHENTICATION_FIELD, CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, CREATION_TIME_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, CURRENT_VERSION_FIELD, ENCRYPTION_INFO_FIELD, ENHANCED_MONITORING_FIELD, OPEN_MONITORING_FIELD, LOGGING_INFO_FIELD, NUMBER_OF_BROKER_NODES_FIELD, STATE_FIELD, STATE_INFO_FIELD, TAGS_FIELD, ZOOKEEPER_CONNECT_STRING_FIELD, ZOOKEEPER_CONNECT_STRING_TLS_FIELD, STORAGE_MODE_FIELD, CUSTOMER_ACTION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ClusterInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String activeOperationArn;
    private final BrokerNodeGroupInfo brokerNodeGroupInfo;
    private final Rebalancing rebalancing;
    private final ClientAuthentication clientAuthentication;
    private final String clusterArn;
    private final String clusterName;
    private final Instant creationTime;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final String currentVersion;
    private final EncryptionInfo encryptionInfo;
    private final String enhancedMonitoring;
    private final OpenMonitoring openMonitoring;
    private final LoggingInfo loggingInfo;
    private final Integer numberOfBrokerNodes;
    private final String state;
    private final StateInfo stateInfo;
    private final Map<String, String> tags;
    private final String zookeeperConnectString;
    private final String zookeeperConnectStringTls;
    private final String storageMode;
    private final String customerActionStatus;

    private ClusterInfo(BuilderImpl builder) {
        this.activeOperationArn = builder.activeOperationArn;
        this.brokerNodeGroupInfo = builder.brokerNodeGroupInfo;
        this.rebalancing = builder.rebalancing;
        this.clientAuthentication = builder.clientAuthentication;
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.creationTime = builder.creationTime;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.currentVersion = builder.currentVersion;
        this.encryptionInfo = builder.encryptionInfo;
        this.enhancedMonitoring = builder.enhancedMonitoring;
        this.openMonitoring = builder.openMonitoring;
        this.loggingInfo = builder.loggingInfo;
        this.numberOfBrokerNodes = builder.numberOfBrokerNodes;
        this.state = builder.state;
        this.stateInfo = builder.stateInfo;
        this.tags = builder.tags;
        this.zookeeperConnectString = builder.zookeeperConnectString;
        this.zookeeperConnectStringTls = builder.zookeeperConnectStringTls;
        this.storageMode = builder.storageMode;
        this.customerActionStatus = builder.customerActionStatus;
    }

    public final String activeOperationArn() {
        return this.activeOperationArn;
    }

    public final BrokerNodeGroupInfo brokerNodeGroupInfo() {
        return this.brokerNodeGroupInfo;
    }

    public final Rebalancing rebalancing() {
        return this.rebalancing;
    }

    public final ClientAuthentication clientAuthentication() {
        return this.clientAuthentication;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public final String currentVersion() {
        return this.currentVersion;
    }

    public final EncryptionInfo encryptionInfo() {
        return this.encryptionInfo;
    }

    public final EnhancedMonitoring enhancedMonitoring() {
        return EnhancedMonitoring.fromValue(this.enhancedMonitoring);
    }

    public final String enhancedMonitoringAsString() {
        return this.enhancedMonitoring;
    }

    public final OpenMonitoring openMonitoring() {
        return this.openMonitoring;
    }

    public final LoggingInfo loggingInfo() {
        return this.loggingInfo;
    }

    public final Integer numberOfBrokerNodes() {
        return this.numberOfBrokerNodes;
    }

    public final ClusterState state() {
        return ClusterState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final StateInfo stateInfo() {
        return this.stateInfo;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final String zookeeperConnectString() {
        return this.zookeeperConnectString;
    }

    public final String zookeeperConnectStringTls() {
        return this.zookeeperConnectStringTls;
    }

    public final StorageMode storageMode() {
        return StorageMode.fromValue(this.storageMode);
    }

    public final String storageModeAsString() {
        return this.storageMode;
    }

    public final CustomerActionStatus customerActionStatus() {
        return CustomerActionStatus.fromValue(this.customerActionStatus);
    }

    public final String customerActionStatusAsString() {
        return this.customerActionStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.activeOperationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerNodeGroupInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.rebalancing());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientAuthentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.enhancedMonitoringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.openMonitoring());
        hashCode = 31 * hashCode + Objects.hashCode(this.loggingInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfBrokerNodes());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectString());
        hashCode = 31 * hashCode + Objects.hashCode(this.zookeeperConnectStringTls());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.customerActionStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInfo)) {
            return false;
        }
        ClusterInfo other = (ClusterInfo)obj;
        return Objects.equals(this.activeOperationArn(), other.activeOperationArn()) && Objects.equals(this.brokerNodeGroupInfo(), other.brokerNodeGroupInfo()) && Objects.equals(this.rebalancing(), other.rebalancing()) && Objects.equals(this.clientAuthentication(), other.clientAuthentication()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && Objects.equals(this.currentVersion(), other.currentVersion()) && Objects.equals(this.encryptionInfo(), other.encryptionInfo()) && Objects.equals(this.enhancedMonitoringAsString(), other.enhancedMonitoringAsString()) && Objects.equals(this.openMonitoring(), other.openMonitoring()) && Objects.equals(this.loggingInfo(), other.loggingInfo()) && Objects.equals(this.numberOfBrokerNodes(), other.numberOfBrokerNodes()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.stateInfo(), other.stateInfo()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.zookeeperConnectString(), other.zookeeperConnectString()) && Objects.equals(this.zookeeperConnectStringTls(), other.zookeeperConnectStringTls()) && Objects.equals(this.storageModeAsString(), other.storageModeAsString()) && Objects.equals(this.customerActionStatusAsString(), other.customerActionStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterInfo").add("ActiveOperationArn", (Object)this.activeOperationArn()).add("BrokerNodeGroupInfo", (Object)this.brokerNodeGroupInfo()).add("Rebalancing", (Object)this.rebalancing()).add("ClientAuthentication", (Object)this.clientAuthentication()).add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("CreationTime", (Object)this.creationTime()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("CurrentVersion", (Object)this.currentVersion()).add("EncryptionInfo", (Object)this.encryptionInfo()).add("EnhancedMonitoring", (Object)this.enhancedMonitoringAsString()).add("OpenMonitoring", (Object)this.openMonitoring()).add("LoggingInfo", (Object)this.loggingInfo()).add("NumberOfBrokerNodes", (Object)this.numberOfBrokerNodes()).add("State", (Object)this.stateAsString()).add("StateInfo", (Object)this.stateInfo()).add("Tags", this.hasTags() ? this.tags() : null).add("ZookeeperConnectString", (Object)this.zookeeperConnectString()).add("ZookeeperConnectStringTls", (Object)this.zookeeperConnectStringTls()).add("StorageMode", (Object)this.storageModeAsString()).add("CustomerActionStatus", (Object)this.customerActionStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ActiveOperationArn": {
                return Optional.ofNullable(clazz.cast(this.activeOperationArn()));
            }
            case "BrokerNodeGroupInfo": {
                return Optional.ofNullable(clazz.cast(this.brokerNodeGroupInfo()));
            }
            case "Rebalancing": {
                return Optional.ofNullable(clazz.cast(this.rebalancing()));
            }
            case "ClientAuthentication": {
                return Optional.ofNullable(clazz.cast(this.clientAuthentication()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "CurrentVersion": {
                return Optional.ofNullable(clazz.cast(this.currentVersion()));
            }
            case "EncryptionInfo": {
                return Optional.ofNullable(clazz.cast(this.encryptionInfo()));
            }
            case "EnhancedMonitoring": {
                return Optional.ofNullable(clazz.cast(this.enhancedMonitoringAsString()));
            }
            case "OpenMonitoring": {
                return Optional.ofNullable(clazz.cast(this.openMonitoring()));
            }
            case "LoggingInfo": {
                return Optional.ofNullable(clazz.cast(this.loggingInfo()));
            }
            case "NumberOfBrokerNodes": {
                return Optional.ofNullable(clazz.cast(this.numberOfBrokerNodes()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StateInfo": {
                return Optional.ofNullable(clazz.cast(this.stateInfo()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ZookeeperConnectString": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectString()));
            }
            case "ZookeeperConnectStringTls": {
                return Optional.ofNullable(clazz.cast(this.zookeeperConnectStringTls()));
            }
            case "StorageMode": {
                return Optional.ofNullable(clazz.cast(this.storageModeAsString()));
            }
            case "CustomerActionStatus": {
                return Optional.ofNullable(clazz.cast(this.customerActionStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("activeOperationArn", ACTIVE_OPERATION_ARN_FIELD);
        map.put("brokerNodeGroupInfo", BROKER_NODE_GROUP_INFO_FIELD);
        map.put("rebalancing", REBALANCING_FIELD);
        map.put("clientAuthentication", CLIENT_AUTHENTICATION_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("creationTime", CREATION_TIME_FIELD);
        map.put("currentBrokerSoftwareInfo", CURRENT_BROKER_SOFTWARE_INFO_FIELD);
        map.put("currentVersion", CURRENT_VERSION_FIELD);
        map.put("encryptionInfo", ENCRYPTION_INFO_FIELD);
        map.put("enhancedMonitoring", ENHANCED_MONITORING_FIELD);
        map.put("openMonitoring", OPEN_MONITORING_FIELD);
        map.put("loggingInfo", LOGGING_INFO_FIELD);
        map.put("numberOfBrokerNodes", NUMBER_OF_BROKER_NODES_FIELD);
        map.put("state", STATE_FIELD);
        map.put("stateInfo", STATE_INFO_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("zookeeperConnectString", ZOOKEEPER_CONNECT_STRING_FIELD);
        map.put("zookeeperConnectStringTls", ZOOKEEPER_CONNECT_STRING_TLS_FIELD);
        map.put("storageMode", STORAGE_MODE_FIELD);
        map.put("customerActionStatus", CUSTOMER_ACTION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ClusterInfo, T> g) {
        return obj -> g.apply((ClusterInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String activeOperationArn;
        private BrokerNodeGroupInfo brokerNodeGroupInfo;
        private Rebalancing rebalancing;
        private ClientAuthentication clientAuthentication;
        private String clusterArn;
        private String clusterName;
        private Instant creationTime;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private String currentVersion;
        private EncryptionInfo encryptionInfo;
        private String enhancedMonitoring;
        private OpenMonitoring openMonitoring;
        private LoggingInfo loggingInfo;
        private Integer numberOfBrokerNodes;
        private String state;
        private StateInfo stateInfo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private String zookeeperConnectString;
        private String zookeeperConnectStringTls;
        private String storageMode;
        private String customerActionStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInfo model) {
            this.activeOperationArn(model.activeOperationArn);
            this.brokerNodeGroupInfo(model.brokerNodeGroupInfo);
            this.rebalancing(model.rebalancing);
            this.clientAuthentication(model.clientAuthentication);
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.creationTime(model.creationTime);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.currentVersion(model.currentVersion);
            this.encryptionInfo(model.encryptionInfo);
            this.enhancedMonitoring(model.enhancedMonitoring);
            this.openMonitoring(model.openMonitoring);
            this.loggingInfo(model.loggingInfo);
            this.numberOfBrokerNodes(model.numberOfBrokerNodes);
            this.state(model.state);
            this.stateInfo(model.stateInfo);
            this.tags(model.tags);
            this.zookeeperConnectString(model.zookeeperConnectString);
            this.zookeeperConnectStringTls(model.zookeeperConnectStringTls);
            this.storageMode(model.storageMode);
            this.customerActionStatus(model.customerActionStatus);
        }

        public final String getActiveOperationArn() {
            return this.activeOperationArn;
        }

        public final void setActiveOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
        }

        @Override
        public final Builder activeOperationArn(String activeOperationArn) {
            this.activeOperationArn = activeOperationArn;
            return this;
        }

        public final BrokerNodeGroupInfo.Builder getBrokerNodeGroupInfo() {
            return this.brokerNodeGroupInfo != null ? this.brokerNodeGroupInfo.toBuilder() : null;
        }

        public final void setBrokerNodeGroupInfo(BrokerNodeGroupInfo.BuilderImpl brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo != null ? brokerNodeGroupInfo.build() : null;
        }

        @Override
        public final Builder brokerNodeGroupInfo(BrokerNodeGroupInfo brokerNodeGroupInfo) {
            this.brokerNodeGroupInfo = brokerNodeGroupInfo;
            return this;
        }

        public final Rebalancing.Builder getRebalancing() {
            return this.rebalancing != null ? this.rebalancing.toBuilder() : null;
        }

        public final void setRebalancing(Rebalancing.BuilderImpl rebalancing) {
            this.rebalancing = rebalancing != null ? rebalancing.build() : null;
        }

        @Override
        public final Builder rebalancing(Rebalancing rebalancing) {
            this.rebalancing = rebalancing;
            return this;
        }

        public final ClientAuthentication.Builder getClientAuthentication() {
            return this.clientAuthentication != null ? this.clientAuthentication.toBuilder() : null;
        }

        public final void setClientAuthentication(ClientAuthentication.BuilderImpl clientAuthentication) {
            this.clientAuthentication = clientAuthentication != null ? clientAuthentication.build() : null;
        }

        @Override
        public final Builder clientAuthentication(ClientAuthentication clientAuthentication) {
            this.clientAuthentication = clientAuthentication;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final String getCurrentVersion() {
            return this.currentVersion;
        }

        public final void setCurrentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
        }

        @Override
        public final Builder currentVersion(String currentVersion) {
            this.currentVersion = currentVersion;
            return this;
        }

        public final EncryptionInfo.Builder getEncryptionInfo() {
            return this.encryptionInfo != null ? this.encryptionInfo.toBuilder() : null;
        }

        public final void setEncryptionInfo(EncryptionInfo.BuilderImpl encryptionInfo) {
            this.encryptionInfo = encryptionInfo != null ? encryptionInfo.build() : null;
        }

        @Override
        public final Builder encryptionInfo(EncryptionInfo encryptionInfo) {
            this.encryptionInfo = encryptionInfo;
            return this;
        }

        public final String getEnhancedMonitoring() {
            return this.enhancedMonitoring;
        }

        public final void setEnhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
        }

        @Override
        public final Builder enhancedMonitoring(String enhancedMonitoring) {
            this.enhancedMonitoring = enhancedMonitoring;
            return this;
        }

        @Override
        public final Builder enhancedMonitoring(EnhancedMonitoring enhancedMonitoring) {
            this.enhancedMonitoring(enhancedMonitoring == null ? null : enhancedMonitoring.toString());
            return this;
        }

        public final OpenMonitoring.Builder getOpenMonitoring() {
            return this.openMonitoring != null ? this.openMonitoring.toBuilder() : null;
        }

        public final void setOpenMonitoring(OpenMonitoring.BuilderImpl openMonitoring) {
            this.openMonitoring = openMonitoring != null ? openMonitoring.build() : null;
        }

        @Override
        public final Builder openMonitoring(OpenMonitoring openMonitoring) {
            this.openMonitoring = openMonitoring;
            return this;
        }

        public final LoggingInfo.Builder getLoggingInfo() {
            return this.loggingInfo != null ? this.loggingInfo.toBuilder() : null;
        }

        public final void setLoggingInfo(LoggingInfo.BuilderImpl loggingInfo) {
            this.loggingInfo = loggingInfo != null ? loggingInfo.build() : null;
        }

        @Override
        public final Builder loggingInfo(LoggingInfo loggingInfo) {
            this.loggingInfo = loggingInfo;
            return this;
        }

        public final Integer getNumberOfBrokerNodes() {
            return this.numberOfBrokerNodes;
        }

        public final void setNumberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
        }

        @Override
        public final Builder numberOfBrokerNodes(Integer numberOfBrokerNodes) {
            this.numberOfBrokerNodes = numberOfBrokerNodes;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ClusterState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final StateInfo.Builder getStateInfo() {
            return this.stateInfo != null ? this.stateInfo.toBuilder() : null;
        }

        public final void setStateInfo(StateInfo.BuilderImpl stateInfo) {
            this.stateInfo = stateInfo != null ? stateInfo.build() : null;
        }

        @Override
        public final Builder stateInfo(StateInfo stateInfo) {
            this.stateInfo = stateInfo;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = ___mapOf__stringCopier.copy(tags);
            return this;
        }

        public final String getZookeeperConnectString() {
            return this.zookeeperConnectString;
        }

        public final void setZookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
        }

        @Override
        public final Builder zookeeperConnectString(String zookeeperConnectString) {
            this.zookeeperConnectString = zookeeperConnectString;
            return this;
        }

        public final String getZookeeperConnectStringTls() {
            return this.zookeeperConnectStringTls;
        }

        public final void setZookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
        }

        @Override
        public final Builder zookeeperConnectStringTls(String zookeeperConnectStringTls) {
            this.zookeeperConnectStringTls = zookeeperConnectStringTls;
            return this;
        }

        public final String getStorageMode() {
            return this.storageMode;
        }

        public final void setStorageMode(String storageMode) {
            this.storageMode = storageMode;
        }

        @Override
        public final Builder storageMode(String storageMode) {
            this.storageMode = storageMode;
            return this;
        }

        @Override
        public final Builder storageMode(StorageMode storageMode) {
            this.storageMode(storageMode == null ? null : storageMode.toString());
            return this;
        }

        public final String getCustomerActionStatus() {
            return this.customerActionStatus;
        }

        public final void setCustomerActionStatus(String customerActionStatus) {
            this.customerActionStatus = customerActionStatus;
        }

        @Override
        public final Builder customerActionStatus(String customerActionStatus) {
            this.customerActionStatus = customerActionStatus;
            return this;
        }

        @Override
        public final Builder customerActionStatus(CustomerActionStatus customerActionStatus) {
            this.customerActionStatus(customerActionStatus == null ? null : customerActionStatus.toString());
            return this;
        }

        public ClusterInfo build() {
            return new ClusterInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInfo> {
        public Builder activeOperationArn(String var1);

        public Builder brokerNodeGroupInfo(BrokerNodeGroupInfo var1);

        default public Builder brokerNodeGroupInfo(Consumer<BrokerNodeGroupInfo.Builder> brokerNodeGroupInfo) {
            return this.brokerNodeGroupInfo((BrokerNodeGroupInfo)((BrokerNodeGroupInfo.Builder)BrokerNodeGroupInfo.builder().applyMutation(brokerNodeGroupInfo)).build());
        }

        public Builder rebalancing(Rebalancing var1);

        default public Builder rebalancing(Consumer<Rebalancing.Builder> rebalancing) {
            return this.rebalancing((Rebalancing)((Rebalancing.Builder)Rebalancing.builder().applyMutation(rebalancing)).build());
        }

        public Builder clientAuthentication(ClientAuthentication var1);

        default public Builder clientAuthentication(Consumer<ClientAuthentication.Builder> clientAuthentication) {
            return this.clientAuthentication((ClientAuthentication)((ClientAuthentication.Builder)ClientAuthentication.builder().applyMutation(clientAuthentication)).build());
        }

        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder creationTime(Instant var1);

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder currentVersion(String var1);

        public Builder encryptionInfo(EncryptionInfo var1);

        default public Builder encryptionInfo(Consumer<EncryptionInfo.Builder> encryptionInfo) {
            return this.encryptionInfo((EncryptionInfo)((EncryptionInfo.Builder)EncryptionInfo.builder().applyMutation(encryptionInfo)).build());
        }

        public Builder enhancedMonitoring(String var1);

        public Builder enhancedMonitoring(EnhancedMonitoring var1);

        public Builder openMonitoring(OpenMonitoring var1);

        default public Builder openMonitoring(Consumer<OpenMonitoring.Builder> openMonitoring) {
            return this.openMonitoring((OpenMonitoring)((OpenMonitoring.Builder)OpenMonitoring.builder().applyMutation(openMonitoring)).build());
        }

        public Builder loggingInfo(LoggingInfo var1);

        default public Builder loggingInfo(Consumer<LoggingInfo.Builder> loggingInfo) {
            return this.loggingInfo((LoggingInfo)((LoggingInfo.Builder)LoggingInfo.builder().applyMutation(loggingInfo)).build());
        }

        public Builder numberOfBrokerNodes(Integer var1);

        public Builder state(String var1);

        public Builder state(ClusterState var1);

        public Builder stateInfo(StateInfo var1);

        default public Builder stateInfo(Consumer<StateInfo.Builder> stateInfo) {
            return this.stateInfo((StateInfo)((StateInfo.Builder)StateInfo.builder().applyMutation(stateInfo)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder zookeeperConnectString(String var1);

        public Builder zookeeperConnectStringTls(String var1);

        public Builder storageMode(String var1);

        public Builder storageMode(StorageMode var1);

        public Builder customerActionStatus(String var1);

        public Builder customerActionStatus(CustomerActionStatus var1);
    }
}

