/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ConfigurationState {
    ACTIVE("ACTIVE"),
    DELETING("DELETING"),
    DELETE_FAILED("DELETE_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ConfigurationState> VALUE_MAP;
    private final String value;

    private ConfigurationState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ConfigurationState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ConfigurationState> knownValues() {
        EnumSet<ConfigurationState> knownValues = EnumSet.allOf(ConfigurationState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ConfigurationState.class, ConfigurationState::toString);
    }
}

