/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.kafka.model.ClusterOperationV2Provisioned;
import software.amazon.awssdk.services.kafka.model.ClusterOperationV2Serverless;
import software.amazon.awssdk.services.kafka.model.ClusterType;
import software.amazon.awssdk.services.kafka.model.ErrorInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterOperationV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterOperationV2> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(ClusterOperationV2.getter(ClusterOperationV2::clusterArn)).setter(ClusterOperationV2.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterType").getter(ClusterOperationV2.getter(ClusterOperationV2::clusterTypeAsString)).setter(ClusterOperationV2.setter(Builder::clusterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterType").build()}).build();
    private static final SdkField<Instant> START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("StartTime").getter(ClusterOperationV2.getter(ClusterOperationV2::startTime)).setter(ClusterOperationV2.setter(Builder::startTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("EndTime").getter(ClusterOperationV2.getter(ClusterOperationV2::endTime)).setter(ClusterOperationV2.setter(Builder::endTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<ErrorInfo> ERROR_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ErrorInfo").getter(ClusterOperationV2.getter(ClusterOperationV2::errorInfo)).setter(ClusterOperationV2.setter(Builder::errorInfo)).constructor(ErrorInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorInfo").build()}).build();
    private static final SdkField<String> OPERATION_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationArn").getter(ClusterOperationV2.getter(ClusterOperationV2::operationArn)).setter(ClusterOperationV2.setter(Builder::operationArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationArn").build()}).build();
    private static final SdkField<String> OPERATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationState").getter(ClusterOperationV2.getter(ClusterOperationV2::operationState)).setter(ClusterOperationV2.setter(Builder::operationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationState").build()}).build();
    private static final SdkField<String> OPERATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OperationType").getter(ClusterOperationV2.getter(ClusterOperationV2::operationType)).setter(ClusterOperationV2.setter(Builder::operationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("operationType").build()}).build();
    private static final SdkField<ClusterOperationV2Provisioned> PROVISIONED_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Provisioned").getter(ClusterOperationV2.getter(ClusterOperationV2::provisioned)).setter(ClusterOperationV2.setter(Builder::provisioned)).constructor(ClusterOperationV2Provisioned::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioned").build()}).build();
    private static final SdkField<ClusterOperationV2Serverless> SERVERLESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Serverless").getter(ClusterOperationV2.getter(ClusterOperationV2::serverless)).setter(ClusterOperationV2.setter(Builder::serverless)).constructor(ClusterOperationV2Serverless::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serverless").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_TYPE_FIELD, START_TIME_FIELD, END_TIME_FIELD, ERROR_INFO_FIELD, OPERATION_ARN_FIELD, OPERATION_STATE_FIELD, OPERATION_TYPE_FIELD, PROVISIONED_FIELD, SERVERLESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("clusterArn", CLUSTER_ARN_FIELD);
            this.put("clusterType", CLUSTER_TYPE_FIELD);
            this.put("startTime", START_TIME_FIELD);
            this.put("endTime", END_TIME_FIELD);
            this.put("errorInfo", ERROR_INFO_FIELD);
            this.put("operationArn", OPERATION_ARN_FIELD);
            this.put("operationState", OPERATION_STATE_FIELD);
            this.put("operationType", OPERATION_TYPE_FIELD);
            this.put("provisioned", PROVISIONED_FIELD);
            this.put("serverless", SERVERLESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterType;
    private final Instant startTime;
    private final Instant endTime;
    private final ErrorInfo errorInfo;
    private final String operationArn;
    private final String operationState;
    private final String operationType;
    private final ClusterOperationV2Provisioned provisioned;
    private final ClusterOperationV2Serverless serverless;

    private ClusterOperationV2(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterType = builder.clusterType;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.errorInfo = builder.errorInfo;
        this.operationArn = builder.operationArn;
        this.operationState = builder.operationState;
        this.operationType = builder.operationType;
        this.provisioned = builder.provisioned;
        this.serverless = builder.serverless;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final ClusterType clusterType() {
        return ClusterType.fromValue(this.clusterType);
    }

    public final String clusterTypeAsString() {
        return this.clusterType;
    }

    public final Instant startTime() {
        return this.startTime;
    }

    public final Instant endTime() {
        return this.endTime;
    }

    public final ErrorInfo errorInfo() {
        return this.errorInfo;
    }

    public final String operationArn() {
        return this.operationArn;
    }

    public final String operationState() {
        return this.operationState;
    }

    public final String operationType() {
        return this.operationType;
    }

    public final ClusterOperationV2Provisioned provisioned() {
        return this.provisioned;
    }

    public final ClusterOperationV2Serverless serverless() {
        return this.serverless;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.endTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationState());
        hashCode = 31 * hashCode + Objects.hashCode(this.operationType());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioned());
        hashCode = 31 * hashCode + Objects.hashCode(this.serverless());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterOperationV2)) {
            return false;
        }
        ClusterOperationV2 other = (ClusterOperationV2)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterTypeAsString(), other.clusterTypeAsString()) && Objects.equals(this.startTime(), other.startTime()) && Objects.equals(this.endTime(), other.endTime()) && Objects.equals(this.errorInfo(), other.errorInfo()) && Objects.equals(this.operationArn(), other.operationArn()) && Objects.equals(this.operationState(), other.operationState()) && Objects.equals(this.operationType(), other.operationType()) && Objects.equals(this.provisioned(), other.provisioned()) && Objects.equals(this.serverless(), other.serverless());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterOperationV2").add("ClusterArn", (Object)this.clusterArn()).add("ClusterType", (Object)this.clusterTypeAsString()).add("StartTime", (Object)this.startTime()).add("EndTime", (Object)this.endTime()).add("ErrorInfo", (Object)this.errorInfo()).add("OperationArn", (Object)this.operationArn()).add("OperationState", (Object)this.operationState()).add("OperationType", (Object)this.operationType()).add("Provisioned", (Object)this.provisioned()).add("Serverless", (Object)this.serverless()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "ClusterType": {
                return Optional.ofNullable(clazz.cast(this.clusterTypeAsString()));
            }
            case "StartTime": {
                return Optional.ofNullable(clazz.cast(this.startTime()));
            }
            case "EndTime": {
                return Optional.ofNullable(clazz.cast(this.endTime()));
            }
            case "ErrorInfo": {
                return Optional.ofNullable(clazz.cast(this.errorInfo()));
            }
            case "OperationArn": {
                return Optional.ofNullable(clazz.cast(this.operationArn()));
            }
            case "OperationState": {
                return Optional.ofNullable(clazz.cast(this.operationState()));
            }
            case "OperationType": {
                return Optional.ofNullable(clazz.cast(this.operationType()));
            }
            case "Provisioned": {
                return Optional.ofNullable(clazz.cast(this.provisioned()));
            }
            case "Serverless": {
                return Optional.ofNullable(clazz.cast(this.serverless()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterOperationV2, T> g) {
        return obj -> g.apply((ClusterOperationV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterType;
        private Instant startTime;
        private Instant endTime;
        private ErrorInfo errorInfo;
        private String operationArn;
        private String operationState;
        private String operationType;
        private ClusterOperationV2Provisioned provisioned;
        private ClusterOperationV2Serverless serverless;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterOperationV2 model) {
            this.clusterArn(model.clusterArn);
            this.clusterType(model.clusterType);
            this.startTime(model.startTime);
            this.endTime(model.endTime);
            this.errorInfo(model.errorInfo);
            this.operationArn(model.operationArn);
            this.operationState(model.operationState);
            this.operationType(model.operationType);
            this.provisioned(model.provisioned);
            this.serverless(model.serverless);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterType() {
            return this.clusterType;
        }

        public final void setClusterType(String clusterType) {
            this.clusterType = clusterType;
        }

        @Override
        public final Builder clusterType(String clusterType) {
            this.clusterType = clusterType;
            return this;
        }

        @Override
        public final Builder clusterType(ClusterType clusterType) {
            this.clusterType(clusterType == null ? null : clusterType.toString());
            return this;
        }

        public final Instant getStartTime() {
            return this.startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return this.endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final ErrorInfo.Builder getErrorInfo() {
            return this.errorInfo != null ? this.errorInfo.toBuilder() : null;
        }

        public final void setErrorInfo(ErrorInfo.BuilderImpl errorInfo) {
            this.errorInfo = errorInfo != null ? errorInfo.build() : null;
        }

        @Override
        public final Builder errorInfo(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            return this;
        }

        public final String getOperationArn() {
            return this.operationArn;
        }

        public final void setOperationArn(String operationArn) {
            this.operationArn = operationArn;
        }

        @Override
        public final Builder operationArn(String operationArn) {
            this.operationArn = operationArn;
            return this;
        }

        public final String getOperationState() {
            return this.operationState;
        }

        public final void setOperationState(String operationState) {
            this.operationState = operationState;
        }

        @Override
        public final Builder operationState(String operationState) {
            this.operationState = operationState;
            return this;
        }

        public final String getOperationType() {
            return this.operationType;
        }

        public final void setOperationType(String operationType) {
            this.operationType = operationType;
        }

        @Override
        public final Builder operationType(String operationType) {
            this.operationType = operationType;
            return this;
        }

        public final ClusterOperationV2Provisioned.Builder getProvisioned() {
            return this.provisioned != null ? this.provisioned.toBuilder() : null;
        }

        public final void setProvisioned(ClusterOperationV2Provisioned.BuilderImpl provisioned) {
            this.provisioned = provisioned != null ? provisioned.build() : null;
        }

        @Override
        public final Builder provisioned(ClusterOperationV2Provisioned provisioned) {
            this.provisioned = provisioned;
            return this;
        }

        public final ClusterOperationV2Serverless.Builder getServerless() {
            return this.serverless != null ? this.serverless.toBuilder() : null;
        }

        public final void setServerless(ClusterOperationV2Serverless.BuilderImpl serverless) {
            this.serverless = serverless != null ? serverless.build() : null;
        }

        @Override
        public final Builder serverless(ClusterOperationV2Serverless serverless) {
            this.serverless = serverless;
            return this;
        }

        public ClusterOperationV2 build() {
            return new ClusterOperationV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterOperationV2> {
        public Builder clusterArn(String var1);

        public Builder clusterType(String var1);

        public Builder clusterType(ClusterType var1);

        public Builder startTime(Instant var1);

        public Builder endTime(Instant var1);

        public Builder errorInfo(ErrorInfo var1);

        default public Builder errorInfo(Consumer<ErrorInfo.Builder> errorInfo) {
            return this.errorInfo((ErrorInfo)((ErrorInfo.Builder)ErrorInfo.builder().applyMutation(errorInfo)).build());
        }

        public Builder operationArn(String var1);

        public Builder operationState(String var1);

        public Builder operationType(String var1);

        public Builder provisioned(ClusterOperationV2Provisioned var1);

        default public Builder provisioned(Consumer<ClusterOperationV2Provisioned.Builder> provisioned) {
            return this.provisioned((ClusterOperationV2Provisioned)((ClusterOperationV2Provisioned.Builder)ClusterOperationV2Provisioned.builder().applyMutation(provisioned)).build());
        }

        public Builder serverless(ClusterOperationV2Serverless var1);

        default public Builder serverless(Consumer<ClusterOperationV2Serverless.Builder> serverless) {
            return this.serverless((ClusterOperationV2Serverless)((ClusterOperationV2Serverless.Builder)ClusterOperationV2Serverless.builder().applyMutation(serverless)).build());
        }
    }
}

