/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.BrokerSoftwareInfo;
import software.amazon.awssdk.services.kafka.model.___listOf__stringCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BrokerNodeInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BrokerNodeInfo> {
    private static final SdkField<String> ATTACHED_ENI_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttachedENIId").getter(BrokerNodeInfo.getter(BrokerNodeInfo::attachedENIId)).setter(BrokerNodeInfo.setter(Builder::attachedENIId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attachedENIId").build()}).build();
    private static final SdkField<Double> BROKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("BrokerId").getter(BrokerNodeInfo.getter(BrokerNodeInfo::brokerId)).setter(BrokerNodeInfo.setter(Builder::brokerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("brokerId").build()}).build();
    private static final SdkField<String> CLIENT_SUBNET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientSubnet").getter(BrokerNodeInfo.getter(BrokerNodeInfo::clientSubnet)).setter(BrokerNodeInfo.setter(Builder::clientSubnet)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientSubnet").build()}).build();
    private static final SdkField<String> CLIENT_VPC_IP_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientVpcIpAddress").getter(BrokerNodeInfo.getter(BrokerNodeInfo::clientVpcIpAddress)).setter(BrokerNodeInfo.setter(Builder::clientVpcIpAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientVpcIpAddress").build()}).build();
    private static final SdkField<BrokerSoftwareInfo> CURRENT_BROKER_SOFTWARE_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CurrentBrokerSoftwareInfo").getter(BrokerNodeInfo.getter(BrokerNodeInfo::currentBrokerSoftwareInfo)).setter(BrokerNodeInfo.setter(Builder::currentBrokerSoftwareInfo)).constructor(BrokerSoftwareInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentBrokerSoftwareInfo").build()}).build();
    private static final SdkField<List<String>> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Endpoints").getter(BrokerNodeInfo.getter(BrokerNodeInfo::endpoints)).setter(BrokerNodeInfo.setter(Builder::endpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTACHED_ENI_ID_FIELD, BROKER_ID_FIELD, CLIENT_SUBNET_FIELD, CLIENT_VPC_IP_ADDRESS_FIELD, CURRENT_BROKER_SOFTWARE_INFO_FIELD, ENDPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("attachedENIId", ATTACHED_ENI_ID_FIELD);
            this.put("brokerId", BROKER_ID_FIELD);
            this.put("clientSubnet", CLIENT_SUBNET_FIELD);
            this.put("clientVpcIpAddress", CLIENT_VPC_IP_ADDRESS_FIELD);
            this.put("currentBrokerSoftwareInfo", CURRENT_BROKER_SOFTWARE_INFO_FIELD);
            this.put("endpoints", ENDPOINTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String attachedENIId;
    private final Double brokerId;
    private final String clientSubnet;
    private final String clientVpcIpAddress;
    private final BrokerSoftwareInfo currentBrokerSoftwareInfo;
    private final List<String> endpoints;

    private BrokerNodeInfo(BuilderImpl builder) {
        this.attachedENIId = builder.attachedENIId;
        this.brokerId = builder.brokerId;
        this.clientSubnet = builder.clientSubnet;
        this.clientVpcIpAddress = builder.clientVpcIpAddress;
        this.currentBrokerSoftwareInfo = builder.currentBrokerSoftwareInfo;
        this.endpoints = builder.endpoints;
    }

    public final String attachedENIId() {
        return this.attachedENIId;
    }

    public final Double brokerId() {
        return this.brokerId;
    }

    public final String clientSubnet() {
        return this.clientSubnet;
    }

    public final String clientVpcIpAddress() {
        return this.clientVpcIpAddress;
    }

    public final BrokerSoftwareInfo currentBrokerSoftwareInfo() {
        return this.currentBrokerSoftwareInfo;
    }

    public final boolean hasEndpoints() {
        return this.endpoints != null && !(this.endpoints instanceof SdkAutoConstructList);
    }

    public final List<String> endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.attachedENIId());
        hashCode = 31 * hashCode + Objects.hashCode(this.brokerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientSubnet());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientVpcIpAddress());
        hashCode = 31 * hashCode + Objects.hashCode(this.currentBrokerSoftwareInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEndpoints() ? this.endpoints() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BrokerNodeInfo)) {
            return false;
        }
        BrokerNodeInfo other = (BrokerNodeInfo)obj;
        return Objects.equals(this.attachedENIId(), other.attachedENIId()) && Objects.equals(this.brokerId(), other.brokerId()) && Objects.equals(this.clientSubnet(), other.clientSubnet()) && Objects.equals(this.clientVpcIpAddress(), other.clientVpcIpAddress()) && Objects.equals(this.currentBrokerSoftwareInfo(), other.currentBrokerSoftwareInfo()) && this.hasEndpoints() == other.hasEndpoints() && Objects.equals(this.endpoints(), other.endpoints());
    }

    public final String toString() {
        return ToString.builder((String)"BrokerNodeInfo").add("AttachedENIId", (Object)this.attachedENIId()).add("BrokerId", (Object)this.brokerId()).add("ClientSubnet", (Object)this.clientSubnet()).add("ClientVpcIpAddress", (Object)this.clientVpcIpAddress()).add("CurrentBrokerSoftwareInfo", (Object)this.currentBrokerSoftwareInfo()).add("Endpoints", this.hasEndpoints() ? this.endpoints() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AttachedENIId": {
                return Optional.ofNullable(clazz.cast(this.attachedENIId()));
            }
            case "BrokerId": {
                return Optional.ofNullable(clazz.cast(this.brokerId()));
            }
            case "ClientSubnet": {
                return Optional.ofNullable(clazz.cast(this.clientSubnet()));
            }
            case "ClientVpcIpAddress": {
                return Optional.ofNullable(clazz.cast(this.clientVpcIpAddress()));
            }
            case "CurrentBrokerSoftwareInfo": {
                return Optional.ofNullable(clazz.cast(this.currentBrokerSoftwareInfo()));
            }
            case "Endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BrokerNodeInfo, T> g) {
        return obj -> g.apply((BrokerNodeInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String attachedENIId;
        private Double brokerId;
        private String clientSubnet;
        private String clientVpcIpAddress;
        private BrokerSoftwareInfo currentBrokerSoftwareInfo;
        private List<String> endpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BrokerNodeInfo model) {
            this.attachedENIId(model.attachedENIId);
            this.brokerId(model.brokerId);
            this.clientSubnet(model.clientSubnet);
            this.clientVpcIpAddress(model.clientVpcIpAddress);
            this.currentBrokerSoftwareInfo(model.currentBrokerSoftwareInfo);
            this.endpoints(model.endpoints);
        }

        public final String getAttachedENIId() {
            return this.attachedENIId;
        }

        public final void setAttachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
        }

        @Override
        public final Builder attachedENIId(String attachedENIId) {
            this.attachedENIId = attachedENIId;
            return this;
        }

        public final Double getBrokerId() {
            return this.brokerId;
        }

        public final void setBrokerId(Double brokerId) {
            this.brokerId = brokerId;
        }

        @Override
        public final Builder brokerId(Double brokerId) {
            this.brokerId = brokerId;
            return this;
        }

        public final String getClientSubnet() {
            return this.clientSubnet;
        }

        public final void setClientSubnet(String clientSubnet) {
            this.clientSubnet = clientSubnet;
        }

        @Override
        public final Builder clientSubnet(String clientSubnet) {
            this.clientSubnet = clientSubnet;
            return this;
        }

        public final String getClientVpcIpAddress() {
            return this.clientVpcIpAddress;
        }

        public final void setClientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
        }

        @Override
        public final Builder clientVpcIpAddress(String clientVpcIpAddress) {
            this.clientVpcIpAddress = clientVpcIpAddress;
            return this;
        }

        public final BrokerSoftwareInfo.Builder getCurrentBrokerSoftwareInfo() {
            return this.currentBrokerSoftwareInfo != null ? this.currentBrokerSoftwareInfo.toBuilder() : null;
        }

        public final void setCurrentBrokerSoftwareInfo(BrokerSoftwareInfo.BuilderImpl currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo != null ? currentBrokerSoftwareInfo.build() : null;
        }

        @Override
        public final Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo currentBrokerSoftwareInfo) {
            this.currentBrokerSoftwareInfo = currentBrokerSoftwareInfo;
            return this;
        }

        public final Collection<String> getEndpoints() {
            if (this.endpoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.endpoints;
        }

        public final void setEndpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
        }

        @Override
        public final Builder endpoints(Collection<String> endpoints) {
            this.endpoints = ___listOf__stringCopier.copy(endpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder endpoints(String ... endpoints) {
            this.endpoints(Arrays.asList(endpoints));
            return this;
        }

        public BrokerNodeInfo build() {
            return new BrokerNodeInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BrokerNodeInfo> {
        public Builder attachedENIId(String var1);

        public Builder brokerId(Double var1);

        public Builder clientSubnet(String var1);

        public Builder clientVpcIpAddress(String var1);

        public Builder currentBrokerSoftwareInfo(BrokerSoftwareInfo var1);

        default public Builder currentBrokerSoftwareInfo(Consumer<BrokerSoftwareInfo.Builder> currentBrokerSoftwareInfo) {
            return this.currentBrokerSoftwareInfo((BrokerSoftwareInfo)((BrokerSoftwareInfo.Builder)BrokerSoftwareInfo.builder().applyMutation(currentBrokerSoftwareInfo)).build());
        }

        public Builder endpoints(Collection<String> var1);

        public Builder endpoints(String ... var1);
    }
}

