/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

/**
 * <p>
 * The type of compression to use producing records to the target cluster.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public enum TargetCompressionType {
    NONE("NONE"),

    GZIP("GZIP"),

    SNAPPY("SNAPPY"),

    LZ4("LZ4"),

    ZSTD("ZSTD"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TargetCompressionType> VALUE_MAP = EnumUtils.uniqueIndex(TargetCompressionType.class,
            TargetCompressionType::toString);

    private final String value;

    private TargetCompressionType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return TargetCompressionType corresponding to the value
     */
    public static TargetCompressionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link TargetCompressionType}s
     */
    public static Set<TargetCompressionType> knownValues() {
        Set<TargetCompressionType> knownValues = EnumSet.allOf(TargetCompressionType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
