/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.kafka.model.___listOf__stringMax256Copier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConsumerGroupReplication
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConsumerGroupReplication> {
    private static final SdkField<List<String>> CONSUMER_GROUPS_TO_EXCLUDE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumerGroupsToExclude").getter(ConsumerGroupReplication.getter(ConsumerGroupReplication::consumerGroupsToExclude)).setter(ConsumerGroupReplication.setter(Builder::consumerGroupsToExclude)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupsToExclude").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONSUMER_GROUPS_TO_REPLICATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ConsumerGroupsToReplicate").getter(ConsumerGroupReplication.getter(ConsumerGroupReplication::consumerGroupsToReplicate)).setter(ConsumerGroupReplication.setter(Builder::consumerGroupsToReplicate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumerGroupsToReplicate").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> DETECT_AND_COPY_NEW_CONSUMER_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DetectAndCopyNewConsumerGroups").getter(ConsumerGroupReplication.getter(ConsumerGroupReplication::detectAndCopyNewConsumerGroups)).setter(ConsumerGroupReplication.setter(Builder::detectAndCopyNewConsumerGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectAndCopyNewConsumerGroups").build()}).build();
    private static final SdkField<Boolean> SYNCHRONISE_CONSUMER_GROUP_OFFSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("SynchroniseConsumerGroupOffsets").getter(ConsumerGroupReplication.getter(ConsumerGroupReplication::synchroniseConsumerGroupOffsets)).setter(ConsumerGroupReplication.setter(Builder::synchroniseConsumerGroupOffsets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("synchroniseConsumerGroupOffsets").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSUMER_GROUPS_TO_EXCLUDE_FIELD, CONSUMER_GROUPS_TO_REPLICATE_FIELD, DETECT_AND_COPY_NEW_CONSUMER_GROUPS_FIELD, SYNCHRONISE_CONSUMER_GROUP_OFFSETS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> consumerGroupsToExclude;
    private final List<String> consumerGroupsToReplicate;
    private final Boolean detectAndCopyNewConsumerGroups;
    private final Boolean synchroniseConsumerGroupOffsets;

    private ConsumerGroupReplication(BuilderImpl builder) {
        this.consumerGroupsToExclude = builder.consumerGroupsToExclude;
        this.consumerGroupsToReplicate = builder.consumerGroupsToReplicate;
        this.detectAndCopyNewConsumerGroups = builder.detectAndCopyNewConsumerGroups;
        this.synchroniseConsumerGroupOffsets = builder.synchroniseConsumerGroupOffsets;
    }

    public final boolean hasConsumerGroupsToExclude() {
        return this.consumerGroupsToExclude != null && !(this.consumerGroupsToExclude instanceof SdkAutoConstructList);
    }

    public final List<String> consumerGroupsToExclude() {
        return this.consumerGroupsToExclude;
    }

    public final boolean hasConsumerGroupsToReplicate() {
        return this.consumerGroupsToReplicate != null && !(this.consumerGroupsToReplicate instanceof SdkAutoConstructList);
    }

    public final List<String> consumerGroupsToReplicate() {
        return this.consumerGroupsToReplicate;
    }

    public final Boolean detectAndCopyNewConsumerGroups() {
        return this.detectAndCopyNewConsumerGroups;
    }

    public final Boolean synchroniseConsumerGroupOffsets() {
        return this.synchroniseConsumerGroupOffsets;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumerGroupsToExclude() ? this.consumerGroupsToExclude() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConsumerGroupsToReplicate() ? this.consumerGroupsToReplicate() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.detectAndCopyNewConsumerGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.synchroniseConsumerGroupOffsets());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumerGroupReplication)) {
            return false;
        }
        ConsumerGroupReplication other = (ConsumerGroupReplication)obj;
        return this.hasConsumerGroupsToExclude() == other.hasConsumerGroupsToExclude() && Objects.equals(this.consumerGroupsToExclude(), other.consumerGroupsToExclude()) && this.hasConsumerGroupsToReplicate() == other.hasConsumerGroupsToReplicate() && Objects.equals(this.consumerGroupsToReplicate(), other.consumerGroupsToReplicate()) && Objects.equals(this.detectAndCopyNewConsumerGroups(), other.detectAndCopyNewConsumerGroups()) && Objects.equals(this.synchroniseConsumerGroupOffsets(), other.synchroniseConsumerGroupOffsets());
    }

    public final String toString() {
        return ToString.builder((String)"ConsumerGroupReplication").add("ConsumerGroupsToExclude", this.hasConsumerGroupsToExclude() ? this.consumerGroupsToExclude() : null).add("ConsumerGroupsToReplicate", this.hasConsumerGroupsToReplicate() ? this.consumerGroupsToReplicate() : null).add("DetectAndCopyNewConsumerGroups", (Object)this.detectAndCopyNewConsumerGroups()).add("SynchroniseConsumerGroupOffsets", (Object)this.synchroniseConsumerGroupOffsets()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConsumerGroupsToExclude": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupsToExclude()));
            }
            case "ConsumerGroupsToReplicate": {
                return Optional.ofNullable(clazz.cast(this.consumerGroupsToReplicate()));
            }
            case "DetectAndCopyNewConsumerGroups": {
                return Optional.ofNullable(clazz.cast(this.detectAndCopyNewConsumerGroups()));
            }
            case "SynchroniseConsumerGroupOffsets": {
                return Optional.ofNullable(clazz.cast(this.synchroniseConsumerGroupOffsets()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConsumerGroupReplication, T> g) {
        return obj -> g.apply((ConsumerGroupReplication)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> consumerGroupsToExclude = DefaultSdkAutoConstructList.getInstance();
        private List<String> consumerGroupsToReplicate = DefaultSdkAutoConstructList.getInstance();
        private Boolean detectAndCopyNewConsumerGroups;
        private Boolean synchroniseConsumerGroupOffsets;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumerGroupReplication model) {
            this.consumerGroupsToExclude(model.consumerGroupsToExclude);
            this.consumerGroupsToReplicate(model.consumerGroupsToReplicate);
            this.detectAndCopyNewConsumerGroups(model.detectAndCopyNewConsumerGroups);
            this.synchroniseConsumerGroupOffsets(model.synchroniseConsumerGroupOffsets);
        }

        public final Collection<String> getConsumerGroupsToExclude() {
            if (this.consumerGroupsToExclude instanceof SdkAutoConstructList) {
                return null;
            }
            return this.consumerGroupsToExclude;
        }

        public final void setConsumerGroupsToExclude(Collection<String> consumerGroupsToExclude) {
            this.consumerGroupsToExclude = ___listOf__stringMax256Copier.copy(consumerGroupsToExclude);
        }

        @Override
        public final Builder consumerGroupsToExclude(Collection<String> consumerGroupsToExclude) {
            this.consumerGroupsToExclude = ___listOf__stringMax256Copier.copy(consumerGroupsToExclude);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerGroupsToExclude(String ... consumerGroupsToExclude) {
            this.consumerGroupsToExclude(Arrays.asList(consumerGroupsToExclude));
            return this;
        }

        public final Collection<String> getConsumerGroupsToReplicate() {
            if (this.consumerGroupsToReplicate instanceof SdkAutoConstructList) {
                return null;
            }
            return this.consumerGroupsToReplicate;
        }

        public final void setConsumerGroupsToReplicate(Collection<String> consumerGroupsToReplicate) {
            this.consumerGroupsToReplicate = ___listOf__stringMax256Copier.copy(consumerGroupsToReplicate);
        }

        @Override
        public final Builder consumerGroupsToReplicate(Collection<String> consumerGroupsToReplicate) {
            this.consumerGroupsToReplicate = ___listOf__stringMax256Copier.copy(consumerGroupsToReplicate);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder consumerGroupsToReplicate(String ... consumerGroupsToReplicate) {
            this.consumerGroupsToReplicate(Arrays.asList(consumerGroupsToReplicate));
            return this;
        }

        public final Boolean getDetectAndCopyNewConsumerGroups() {
            return this.detectAndCopyNewConsumerGroups;
        }

        public final void setDetectAndCopyNewConsumerGroups(Boolean detectAndCopyNewConsumerGroups) {
            this.detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups;
        }

        @Override
        public final Builder detectAndCopyNewConsumerGroups(Boolean detectAndCopyNewConsumerGroups) {
            this.detectAndCopyNewConsumerGroups = detectAndCopyNewConsumerGroups;
            return this;
        }

        public final Boolean getSynchroniseConsumerGroupOffsets() {
            return this.synchroniseConsumerGroupOffsets;
        }

        public final void setSynchroniseConsumerGroupOffsets(Boolean synchroniseConsumerGroupOffsets) {
            this.synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets;
        }

        @Override
        public final Builder synchroniseConsumerGroupOffsets(Boolean synchroniseConsumerGroupOffsets) {
            this.synchroniseConsumerGroupOffsets = synchroniseConsumerGroupOffsets;
            return this;
        }

        public ConsumerGroupReplication build() {
            return new ConsumerGroupReplication(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConsumerGroupReplication> {
        public Builder consumerGroupsToExclude(Collection<String> var1);

        public Builder consumerGroupsToExclude(String ... var1);

        public Builder consumerGroupsToReplicate(Collection<String> var1);

        public Builder consumerGroupsToReplicate(String ... var1);

        public Builder detectAndCopyNewConsumerGroups(Boolean var1);

        public Builder synchroniseConsumerGroupOffsets(Boolean var1);
    }
}

