/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.kafka.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum StorageMode {
    LOCAL("LOCAL"),
    TIERED("TIERED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, StorageMode> VALUE_MAP;
    private final String value;

    private StorageMode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StorageMode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StorageMode> knownValues() {
        EnumSet<StorageMode> knownValues = EnumSet.allOf(StorageMode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(StorageMode.class, StorageMode::toString);
    }
}

