/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeAsyncClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse;

public class ListEncoderConfigurationsPublisher
implements SdkPublisher<ListEncoderConfigurationsResponse> {
    private final IvsRealTimeAsyncClient client;
    private final ListEncoderConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEncoderConfigurationsPublisher(IvsRealTimeAsyncClient client, ListEncoderConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEncoderConfigurationsPublisher(IvsRealTimeAsyncClient client, ListEncoderConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEncoderConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEncoderConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListEncoderConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListEncoderConfigurationsResponse> {
        private ListEncoderConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEncoderConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEncoderConfigurationsResponse> nextPage(ListEncoderConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEncoderConfigurationsPublisher.this.client.listEncoderConfigurations(ListEncoderConfigurationsPublisher.this.firstRequest);
            }
            return ListEncoderConfigurationsPublisher.this.client.listEncoderConfigurations((ListEncoderConfigurationsRequest)((Object)ListEncoderConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

