/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListCompositionsResponse;

public class ListCompositionsIterable
implements SdkIterable<ListCompositionsResponse> {
    private final IvsRealTimeClient client;
    private final ListCompositionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListCompositionsIterable(IvsRealTimeClient client, ListCompositionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListCompositionsResponseFetcher();
    }

    public Iterator<ListCompositionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListCompositionsResponseFetcher
    implements SyncPageFetcher<ListCompositionsResponse> {
        private ListCompositionsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompositionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListCompositionsResponse nextPage(ListCompositionsResponse previousPage) {
            if (previousPage == null) {
                return ListCompositionsIterable.this.client.listCompositions(ListCompositionsIterable.this.firstRequest);
            }
            return ListCompositionsIterable.this.client.listCompositions((ListCompositionsRequest)((Object)ListCompositionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

