/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ivsrealtime.model.AutoParticipantRecordingConfiguration;
import software.amazon.awssdk.services.ivsrealtime.model.StageEndpoints;
import software.amazon.awssdk.services.ivsrealtime.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Stage
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Stage> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Stage.getter(Stage::arn)).setter(Stage.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Stage.getter(Stage::name)).setter(Stage.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> ACTIVE_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("activeSessionId").getter(Stage.getter(Stage::activeSessionId)).setter(Stage.setter(Builder::activeSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("activeSessionId").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Stage.getter(Stage::tags)).setter(Stage.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AutoParticipantRecordingConfiguration> AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("autoParticipantRecordingConfiguration").getter(Stage.getter(Stage::autoParticipantRecordingConfiguration)).setter(Stage.setter(Builder::autoParticipantRecordingConfiguration)).constructor(AutoParticipantRecordingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoParticipantRecordingConfiguration").build()}).build();
    private static final SdkField<StageEndpoints> ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("endpoints").getter(Stage.getter(Stage::endpoints)).setter(Stage.setter(Builder::endpoints)).constructor(StageEndpoints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endpoints").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD, ACTIVE_SESSION_ID_FIELD, TAGS_FIELD, AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD, ENDPOINTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Stage.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String name;
    private final String activeSessionId;
    private final Map<String, String> tags;
    private final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;
    private final StageEndpoints endpoints;

    private Stage(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.activeSessionId = builder.activeSessionId;
        this.tags = builder.tags;
        this.autoParticipantRecordingConfiguration = builder.autoParticipantRecordingConfiguration;
        this.endpoints = builder.endpoints;
    }

    public final String arn() {
        return this.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String activeSessionId() {
        return this.activeSessionId;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration() {
        return this.autoParticipantRecordingConfiguration;
    }

    public final StageEndpoints endpoints() {
        return this.endpoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.activeSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.autoParticipantRecordingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpoints());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Stage)) {
            return false;
        }
        Stage other = (Stage)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.activeSessionId(), other.activeSessionId()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.autoParticipantRecordingConfiguration(), other.autoParticipantRecordingConfiguration()) && Objects.equals(this.endpoints(), other.endpoints());
    }

    public final String toString() {
        return ToString.builder((String)"Stage").add("Arn", (Object)this.arn()).add("Name", (Object)this.name()).add("ActiveSessionId", (Object)this.activeSessionId()).add("Tags", this.hasTags() ? this.tags() : null).add("AutoParticipantRecordingConfiguration", (Object)this.autoParticipantRecordingConfiguration()).add("Endpoints", (Object)this.endpoints()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "activeSessionId": {
                return Optional.ofNullable(clazz.cast(this.activeSessionId()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "autoParticipantRecordingConfiguration": {
                return Optional.ofNullable(clazz.cast(this.autoParticipantRecordingConfiguration()));
            }
            case "endpoints": {
                return Optional.ofNullable(clazz.cast(this.endpoints()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("arn", ARN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("activeSessionId", ACTIVE_SESSION_ID_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("autoParticipantRecordingConfiguration", AUTO_PARTICIPANT_RECORDING_CONFIGURATION_FIELD);
        map.put("endpoints", ENDPOINTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Stage, T> g) {
        return obj -> g.apply((Stage)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String name;
        private String activeSessionId;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration;
        private StageEndpoints endpoints;

        private BuilderImpl() {
        }

        private BuilderImpl(Stage model) {
            this.arn(model.arn);
            this.name(model.name);
            this.activeSessionId(model.activeSessionId);
            this.tags(model.tags);
            this.autoParticipantRecordingConfiguration(model.autoParticipantRecordingConfiguration);
            this.endpoints(model.endpoints);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getActiveSessionId() {
            return this.activeSessionId;
        }

        public final void setActiveSessionId(String activeSessionId) {
            this.activeSessionId = activeSessionId;
        }

        @Override
        public final Builder activeSessionId(String activeSessionId) {
            this.activeSessionId = activeSessionId;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final AutoParticipantRecordingConfiguration.Builder getAutoParticipantRecordingConfiguration() {
            return this.autoParticipantRecordingConfiguration != null ? this.autoParticipantRecordingConfiguration.toBuilder() : null;
        }

        public final void setAutoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration.BuilderImpl autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration != null ? autoParticipantRecordingConfiguration.build() : null;
        }

        @Override
        public final Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration autoParticipantRecordingConfiguration) {
            this.autoParticipantRecordingConfiguration = autoParticipantRecordingConfiguration;
            return this;
        }

        public final StageEndpoints.Builder getEndpoints() {
            return this.endpoints != null ? this.endpoints.toBuilder() : null;
        }

        public final void setEndpoints(StageEndpoints.BuilderImpl endpoints) {
            this.endpoints = endpoints != null ? endpoints.build() : null;
        }

        @Override
        public final Builder endpoints(StageEndpoints endpoints) {
            this.endpoints = endpoints;
            return this;
        }

        public Stage build() {
            return new Stage(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Stage> {
        public Builder arn(String var1);

        public Builder name(String var1);

        public Builder activeSessionId(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder autoParticipantRecordingConfiguration(AutoParticipantRecordingConfiguration var1);

        default public Builder autoParticipantRecordingConfiguration(Consumer<AutoParticipantRecordingConfiguration.Builder> autoParticipantRecordingConfiguration) {
            return this.autoParticipantRecordingConfiguration((AutoParticipantRecordingConfiguration)((AutoParticipantRecordingConfiguration.Builder)AutoParticipantRecordingConfiguration.builder().applyMutation(autoParticipantRecordingConfiguration)).build());
        }

        public Builder endpoints(StageEndpoints var1);

        default public Builder endpoints(Consumer<StageEndpoints.Builder> endpoints) {
            return this.endpoints((StageEndpoints)((StageEndpoints.Builder)StageEndpoints.builder().applyMutation(endpoints)).build());
        }
    }
}

