/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ivsrealtime.model.VideoAspectRatio;
import software.amazon.awssdk.services.ivsrealtime.model.VideoFillMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GridConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GridConfiguration> {
    private static final SdkField<String> FEATURED_PARTICIPANT_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("featuredParticipantAttribute").getter(GridConfiguration.getter(GridConfiguration::featuredParticipantAttribute)).setter(GridConfiguration.setter(Builder::featuredParticipantAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("featuredParticipantAttribute").build()}).build();
    private static final SdkField<Boolean> OMIT_STOPPED_VIDEO_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("omitStoppedVideo").getter(GridConfiguration.getter(GridConfiguration::omitStoppedVideo)).setter(GridConfiguration.setter(Builder::omitStoppedVideo)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("omitStoppedVideo").build()}).build();
    private static final SdkField<String> VIDEO_ASPECT_RATIO_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("videoAspectRatio").getter(GridConfiguration.getter(GridConfiguration::videoAspectRatioAsString)).setter(GridConfiguration.setter(Builder::videoAspectRatio)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoAspectRatio").build()}).build();
    private static final SdkField<String> VIDEO_FILL_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("videoFillMode").getter(GridConfiguration.getter(GridConfiguration::videoFillModeAsString)).setter(GridConfiguration.setter(Builder::videoFillMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("videoFillMode").build()}).build();
    private static final SdkField<Integer> GRID_GAP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("gridGap").getter(GridConfiguration.getter(GridConfiguration::gridGap)).setter(GridConfiguration.setter(Builder::gridGap)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("gridGap").build()}).build();
    private static final SdkField<String> PARTICIPANT_ORDER_ATTRIBUTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("participantOrderAttribute").getter(GridConfiguration.getter(GridConfiguration::participantOrderAttribute)).setter(GridConfiguration.setter(Builder::participantOrderAttribute)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("participantOrderAttribute").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FEATURED_PARTICIPANT_ATTRIBUTE_FIELD, OMIT_STOPPED_VIDEO_FIELD, VIDEO_ASPECT_RATIO_FIELD, VIDEO_FILL_MODE_FIELD, GRID_GAP_FIELD, PARTICIPANT_ORDER_ATTRIBUTE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GridConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String featuredParticipantAttribute;
    private final Boolean omitStoppedVideo;
    private final String videoAspectRatio;
    private final String videoFillMode;
    private final Integer gridGap;
    private final String participantOrderAttribute;

    private GridConfiguration(BuilderImpl builder) {
        this.featuredParticipantAttribute = builder.featuredParticipantAttribute;
        this.omitStoppedVideo = builder.omitStoppedVideo;
        this.videoAspectRatio = builder.videoAspectRatio;
        this.videoFillMode = builder.videoFillMode;
        this.gridGap = builder.gridGap;
        this.participantOrderAttribute = builder.participantOrderAttribute;
    }

    public final String featuredParticipantAttribute() {
        return this.featuredParticipantAttribute;
    }

    public final Boolean omitStoppedVideo() {
        return this.omitStoppedVideo;
    }

    public final VideoAspectRatio videoAspectRatio() {
        return VideoAspectRatio.fromValue(this.videoAspectRatio);
    }

    public final String videoAspectRatioAsString() {
        return this.videoAspectRatio;
    }

    public final VideoFillMode videoFillMode() {
        return VideoFillMode.fromValue(this.videoFillMode);
    }

    public final String videoFillModeAsString() {
        return this.videoFillMode;
    }

    public final Integer gridGap() {
        return this.gridGap;
    }

    public final String participantOrderAttribute() {
        return this.participantOrderAttribute;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.featuredParticipantAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(this.omitStoppedVideo());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoAspectRatioAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.videoFillModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.gridGap());
        hashCode = 31 * hashCode + Objects.hashCode(this.participantOrderAttribute());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GridConfiguration)) {
            return false;
        }
        GridConfiguration other = (GridConfiguration)obj;
        return Objects.equals(this.featuredParticipantAttribute(), other.featuredParticipantAttribute()) && Objects.equals(this.omitStoppedVideo(), other.omitStoppedVideo()) && Objects.equals(this.videoAspectRatioAsString(), other.videoAspectRatioAsString()) && Objects.equals(this.videoFillModeAsString(), other.videoFillModeAsString()) && Objects.equals(this.gridGap(), other.gridGap()) && Objects.equals(this.participantOrderAttribute(), other.participantOrderAttribute());
    }

    public final String toString() {
        return ToString.builder((String)"GridConfiguration").add("FeaturedParticipantAttribute", (Object)this.featuredParticipantAttribute()).add("OmitStoppedVideo", (Object)this.omitStoppedVideo()).add("VideoAspectRatio", (Object)this.videoAspectRatioAsString()).add("VideoFillMode", (Object)this.videoFillModeAsString()).add("GridGap", (Object)this.gridGap()).add("ParticipantOrderAttribute", (Object)this.participantOrderAttribute()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "featuredParticipantAttribute": {
                return Optional.ofNullable(clazz.cast(this.featuredParticipantAttribute()));
            }
            case "omitStoppedVideo": {
                return Optional.ofNullable(clazz.cast(this.omitStoppedVideo()));
            }
            case "videoAspectRatio": {
                return Optional.ofNullable(clazz.cast(this.videoAspectRatioAsString()));
            }
            case "videoFillMode": {
                return Optional.ofNullable(clazz.cast(this.videoFillModeAsString()));
            }
            case "gridGap": {
                return Optional.ofNullable(clazz.cast(this.gridGap()));
            }
            case "participantOrderAttribute": {
                return Optional.ofNullable(clazz.cast(this.participantOrderAttribute()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("featuredParticipantAttribute", FEATURED_PARTICIPANT_ATTRIBUTE_FIELD);
        map.put("omitStoppedVideo", OMIT_STOPPED_VIDEO_FIELD);
        map.put("videoAspectRatio", VIDEO_ASPECT_RATIO_FIELD);
        map.put("videoFillMode", VIDEO_FILL_MODE_FIELD);
        map.put("gridGap", GRID_GAP_FIELD);
        map.put("participantOrderAttribute", PARTICIPANT_ORDER_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GridConfiguration, T> g) {
        return obj -> g.apply((GridConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String featuredParticipantAttribute;
        private Boolean omitStoppedVideo;
        private String videoAspectRatio;
        private String videoFillMode;
        private Integer gridGap;
        private String participantOrderAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(GridConfiguration model) {
            this.featuredParticipantAttribute(model.featuredParticipantAttribute);
            this.omitStoppedVideo(model.omitStoppedVideo);
            this.videoAspectRatio(model.videoAspectRatio);
            this.videoFillMode(model.videoFillMode);
            this.gridGap(model.gridGap);
            this.participantOrderAttribute(model.participantOrderAttribute);
        }

        public final String getFeaturedParticipantAttribute() {
            return this.featuredParticipantAttribute;
        }

        public final void setFeaturedParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
        }

        @Override
        public final Builder featuredParticipantAttribute(String featuredParticipantAttribute) {
            this.featuredParticipantAttribute = featuredParticipantAttribute;
            return this;
        }

        public final Boolean getOmitStoppedVideo() {
            return this.omitStoppedVideo;
        }

        public final void setOmitStoppedVideo(Boolean omitStoppedVideo) {
            this.omitStoppedVideo = omitStoppedVideo;
        }

        @Override
        public final Builder omitStoppedVideo(Boolean omitStoppedVideo) {
            this.omitStoppedVideo = omitStoppedVideo;
            return this;
        }

        public final String getVideoAspectRatio() {
            return this.videoAspectRatio;
        }

        public final void setVideoAspectRatio(String videoAspectRatio) {
            this.videoAspectRatio = videoAspectRatio;
        }

        @Override
        public final Builder videoAspectRatio(String videoAspectRatio) {
            this.videoAspectRatio = videoAspectRatio;
            return this;
        }

        @Override
        public final Builder videoAspectRatio(VideoAspectRatio videoAspectRatio) {
            this.videoAspectRatio(videoAspectRatio == null ? null : videoAspectRatio.toString());
            return this;
        }

        public final String getVideoFillMode() {
            return this.videoFillMode;
        }

        public final void setVideoFillMode(String videoFillMode) {
            this.videoFillMode = videoFillMode;
        }

        @Override
        public final Builder videoFillMode(String videoFillMode) {
            this.videoFillMode = videoFillMode;
            return this;
        }

        @Override
        public final Builder videoFillMode(VideoFillMode videoFillMode) {
            this.videoFillMode(videoFillMode == null ? null : videoFillMode.toString());
            return this;
        }

        public final Integer getGridGap() {
            return this.gridGap;
        }

        public final void setGridGap(Integer gridGap) {
            this.gridGap = gridGap;
        }

        @Override
        public final Builder gridGap(Integer gridGap) {
            this.gridGap = gridGap;
            return this;
        }

        public final String getParticipantOrderAttribute() {
            return this.participantOrderAttribute;
        }

        public final void setParticipantOrderAttribute(String participantOrderAttribute) {
            this.participantOrderAttribute = participantOrderAttribute;
        }

        @Override
        public final Builder participantOrderAttribute(String participantOrderAttribute) {
            this.participantOrderAttribute = participantOrderAttribute;
            return this;
        }

        public GridConfiguration build() {
            return new GridConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GridConfiguration> {
        public Builder featuredParticipantAttribute(String var1);

        public Builder omitStoppedVideo(Boolean var1);

        public Builder videoAspectRatio(String var1);

        public Builder videoAspectRatio(VideoAspectRatio var1);

        public Builder videoFillMode(String var1);

        public Builder videoFillMode(VideoFillMode var1);

        public Builder gridGap(Integer var1);

        public Builder participantOrderAttribute(String var1);
    }
}

