/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListPublicKeysResponse;
import software.amazon.awssdk.services.ivsrealtime.model.PublicKeySummary;

public class ListPublicKeysIterable
implements SdkIterable<ListPublicKeysResponse> {
    private final IvsRealTimeClient client;
    private final ListPublicKeysRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPublicKeysIterable(IvsRealTimeClient client, ListPublicKeysRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPublicKeysResponseFetcher();
    }

    public Iterator<ListPublicKeysResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<PublicKeySummary> publicKeys() {
        Function<ListPublicKeysResponse, Iterator> getIterator = response -> {
            if (response != null && response.publicKeys() != null) {
                return response.publicKeys().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPublicKeysResponseFetcher
    implements SyncPageFetcher<ListPublicKeysResponse> {
        private ListPublicKeysResponseFetcher() {
        }

        public boolean hasNextPage(ListPublicKeysResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPublicKeysResponse nextPage(ListPublicKeysResponse previousPage) {
            if (previousPage == null) {
                return ListPublicKeysIterable.this.client.listPublicKeys(ListPublicKeysIterable.this.firstRequest);
            }
            return ListPublicKeysIterable.this.client.listPublicKeys((ListPublicKeysRequest)((Object)ListPublicKeysIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

