/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivsrealtime.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivsrealtime.IvsRealTimeClient;
import software.amazon.awssdk.services.ivsrealtime.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsRequest;
import software.amazon.awssdk.services.ivsrealtime.model.ListEncoderConfigurationsResponse;

public class ListEncoderConfigurationsIterable
implements SdkIterable<ListEncoderConfigurationsResponse> {
    private final IvsRealTimeClient client;
    private final ListEncoderConfigurationsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEncoderConfigurationsIterable(IvsRealTimeClient client, ListEncoderConfigurationsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEncoderConfigurationsResponseFetcher();
    }

    public Iterator<ListEncoderConfigurationsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListEncoderConfigurationsResponseFetcher
    implements SyncPageFetcher<ListEncoderConfigurationsResponse> {
        private ListEncoderConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEncoderConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEncoderConfigurationsResponse nextPage(ListEncoderConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEncoderConfigurationsIterable.this.client.listEncoderConfigurations(ListEncoderConfigurationsIterable.this.firstRequest);
            }
            return ListEncoderConfigurationsIterable.this.client.listEncoderConfigurations((ListEncoderConfigurationsRequest)((Object)ListEncoderConfigurationsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

