/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ThumbnailConfigurationResolution {
    SD("SD"),
    HD("HD"),
    FULL_HD("FULL_HD"),
    LOWEST_RESOLUTION("LOWEST_RESOLUTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ThumbnailConfigurationResolution> VALUE_MAP;
    private final String value;

    private ThumbnailConfigurationResolution(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ThumbnailConfigurationResolution fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ThumbnailConfigurationResolution> knownValues() {
        EnumSet<ThumbnailConfigurationResolution> knownValues = EnumSet.allOf(ThumbnailConfigurationResolution.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ThumbnailConfigurationResolution.class, ThumbnailConfigurationResolution::toString);
    }
}

