/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ivs.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ivs.IvsClient;
import software.amazon.awssdk.services.ivs.internal.UserAgentUtils;
import software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesRequest;
import software.amazon.awssdk.services.ivs.model.ListPlaybackRestrictionPoliciesResponse;

public class ListPlaybackRestrictionPoliciesIterable
implements SdkIterable<ListPlaybackRestrictionPoliciesResponse> {
    private final IvsClient client;
    private final ListPlaybackRestrictionPoliciesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlaybackRestrictionPoliciesIterable(IvsClient client, ListPlaybackRestrictionPoliciesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlaybackRestrictionPoliciesResponseFetcher();
    }

    public Iterator<ListPlaybackRestrictionPoliciesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPlaybackRestrictionPoliciesResponseFetcher
    implements SyncPageFetcher<ListPlaybackRestrictionPoliciesResponse> {
        private ListPlaybackRestrictionPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListPlaybackRestrictionPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlaybackRestrictionPoliciesResponse nextPage(ListPlaybackRestrictionPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListPlaybackRestrictionPoliciesIterable.this.client.listPlaybackRestrictionPolicies(ListPlaybackRestrictionPoliciesIterable.this.firstRequest);
            }
            return ListPlaybackRestrictionPoliciesIterable.this.client.listPlaybackRestrictionPolicies((ListPlaybackRestrictionPoliciesRequest)((Object)ListPlaybackRestrictionPoliciesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

