/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PositionSolverType {
    GNSS("GNSS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PositionSolverType> VALUE_MAP;
    private final String value;

    private PositionSolverType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PositionSolverType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PositionSolverType> knownValues() {
        EnumSet<PositionSolverType> knownValues = EnumSet.allOf(PositionSolverType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PositionSolverType.class, PositionSolverType::toString);
    }
}

