/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotwireless.IotWirelessAsyncClient;
import software.amazon.awssdk.services.iotwireless.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsRequest;
import software.amazon.awssdk.services.iotwireless.model.ListPositionConfigurationsResponse;

public class ListPositionConfigurationsPublisher
implements SdkPublisher<ListPositionConfigurationsResponse> {
    private final IotWirelessAsyncClient client;
    private final ListPositionConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPositionConfigurationsPublisher(IotWirelessAsyncClient client, ListPositionConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPositionConfigurationsPublisher(IotWirelessAsyncClient client, ListPositionConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPositionConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPositionConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPositionConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListPositionConfigurationsResponse> {
        private ListPositionConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListPositionConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPositionConfigurationsResponse> nextPage(ListPositionConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListPositionConfigurationsPublisher.this.client.listPositionConfigurations(ListPositionConfigurationsPublisher.this.firstRequest);
            }
            return ListPositionConfigurationsPublisher.this.client.listPositionConfigurations((ListPositionConfigurationsRequest)((Object)ListPositionConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

