/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum WirelessDeviceEvent {
    JOIN("Join"),
    REJOIN("Rejoin"),
    UPLINK_DATA("Uplink_Data"),
    DOWNLINK_DATA("Downlink_Data"),
    REGISTRATION("Registration"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, WirelessDeviceEvent> VALUE_MAP;
    private final String value;

    private WirelessDeviceEvent(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static WirelessDeviceEvent fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<WirelessDeviceEvent> knownValues() {
        EnumSet<WirelessDeviceEvent> knownValues = EnumSet.allOf(WirelessDeviceEvent.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(WirelessDeviceEvent.class, WirelessDeviceEvent::toString);
    }
}

