/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotwireless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadata;
import software.amazon.awssdk.services.iotwireless.model.LoRaWANGatewayMetadataListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LoRaWANDeviceMetadata
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LoRaWANDeviceMetadata> {
    private static final SdkField<String> DEV_EUI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DevEui").getter(LoRaWANDeviceMetadata.getter(LoRaWANDeviceMetadata::devEui)).setter(LoRaWANDeviceMetadata.setter(Builder::devEui)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DevEui").build()}).build();
    private static final SdkField<Integer> F_PORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("FPort").getter(LoRaWANDeviceMetadata.getter(LoRaWANDeviceMetadata::fPort)).setter(LoRaWANDeviceMetadata.setter(Builder::fPort)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FPort").build()}).build();
    private static final SdkField<Integer> DATA_RATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("DataRate").getter(LoRaWANDeviceMetadata.getter(LoRaWANDeviceMetadata::dataRate)).setter(LoRaWANDeviceMetadata.setter(Builder::dataRate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataRate").build()}).build();
    private static final SdkField<Integer> FREQUENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Frequency").getter(LoRaWANDeviceMetadata.getter(LoRaWANDeviceMetadata::frequency)).setter(LoRaWANDeviceMetadata.setter(Builder::frequency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()}).build();
    private static final SdkField<String> TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Timestamp").getter(LoRaWANDeviceMetadata.getter(LoRaWANDeviceMetadata::timestamp)).setter(LoRaWANDeviceMetadata.setter(Builder::timestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timestamp").build()}).build();
    private static final SdkField<List<LoRaWANGatewayMetadata>> GATEWAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Gateways").getter(LoRaWANDeviceMetadata.getter(LoRaWANDeviceMetadata::gateways)).setter(LoRaWANDeviceMetadata.setter(Builder::gateways)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Gateways").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LoRaWANGatewayMetadata::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEV_EUI_FIELD, F_PORT_FIELD, DATA_RATE_FIELD, FREQUENCY_FIELD, TIMESTAMP_FIELD, GATEWAYS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String devEui;
    private final Integer fPort;
    private final Integer dataRate;
    private final Integer frequency;
    private final String timestamp;
    private final List<LoRaWANGatewayMetadata> gateways;

    private LoRaWANDeviceMetadata(BuilderImpl builder) {
        this.devEui = builder.devEui;
        this.fPort = builder.fPort;
        this.dataRate = builder.dataRate;
        this.frequency = builder.frequency;
        this.timestamp = builder.timestamp;
        this.gateways = builder.gateways;
    }

    public final String devEui() {
        return this.devEui;
    }

    public final Integer fPort() {
        return this.fPort;
    }

    public final Integer dataRate() {
        return this.dataRate;
    }

    public final Integer frequency() {
        return this.frequency;
    }

    public final String timestamp() {
        return this.timestamp;
    }

    public final boolean hasGateways() {
        return this.gateways != null && !(this.gateways instanceof SdkAutoConstructList);
    }

    public final List<LoRaWANGatewayMetadata> gateways() {
        return this.gateways;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.devEui());
        hashCode = 31 * hashCode + Objects.hashCode(this.fPort());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataRate());
        hashCode = 31 * hashCode + Objects.hashCode(this.frequency());
        hashCode = 31 * hashCode + Objects.hashCode(this.timestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGateways() ? this.gateways() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LoRaWANDeviceMetadata)) {
            return false;
        }
        LoRaWANDeviceMetadata other = (LoRaWANDeviceMetadata)obj;
        return Objects.equals(this.devEui(), other.devEui()) && Objects.equals(this.fPort(), other.fPort()) && Objects.equals(this.dataRate(), other.dataRate()) && Objects.equals(this.frequency(), other.frequency()) && Objects.equals(this.timestamp(), other.timestamp()) && this.hasGateways() == other.hasGateways() && Objects.equals(this.gateways(), other.gateways());
    }

    public final String toString() {
        return ToString.builder((String)"LoRaWANDeviceMetadata").add("DevEui", (Object)this.devEui()).add("FPort", (Object)this.fPort()).add("DataRate", (Object)this.dataRate()).add("Frequency", (Object)this.frequency()).add("Timestamp", (Object)this.timestamp()).add("Gateways", this.hasGateways() ? this.gateways() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DevEui": {
                return Optional.ofNullable(clazz.cast(this.devEui()));
            }
            case "FPort": {
                return Optional.ofNullable(clazz.cast(this.fPort()));
            }
            case "DataRate": {
                return Optional.ofNullable(clazz.cast(this.dataRate()));
            }
            case "Frequency": {
                return Optional.ofNullable(clazz.cast(this.frequency()));
            }
            case "Timestamp": {
                return Optional.ofNullable(clazz.cast(this.timestamp()));
            }
            case "Gateways": {
                return Optional.ofNullable(clazz.cast(this.gateways()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LoRaWANDeviceMetadata, T> g) {
        return obj -> g.apply((LoRaWANDeviceMetadata)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String devEui;
        private Integer fPort;
        private Integer dataRate;
        private Integer frequency;
        private String timestamp;
        private List<LoRaWANGatewayMetadata> gateways = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LoRaWANDeviceMetadata model) {
            this.devEui(model.devEui);
            this.fPort(model.fPort);
            this.dataRate(model.dataRate);
            this.frequency(model.frequency);
            this.timestamp(model.timestamp);
            this.gateways(model.gateways);
        }

        public final String getDevEui() {
            return this.devEui;
        }

        public final void setDevEui(String devEui) {
            this.devEui = devEui;
        }

        @Override
        public final Builder devEui(String devEui) {
            this.devEui = devEui;
            return this;
        }

        public final Integer getFPort() {
            return this.fPort;
        }

        public final void setFPort(Integer fPort) {
            this.fPort = fPort;
        }

        @Override
        public final Builder fPort(Integer fPort) {
            this.fPort = fPort;
            return this;
        }

        public final Integer getDataRate() {
            return this.dataRate;
        }

        public final void setDataRate(Integer dataRate) {
            this.dataRate = dataRate;
        }

        @Override
        public final Builder dataRate(Integer dataRate) {
            this.dataRate = dataRate;
            return this;
        }

        public final Integer getFrequency() {
            return this.frequency;
        }

        public final void setFrequency(Integer frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(Integer frequency) {
            this.frequency = frequency;
            return this;
        }

        public final String getTimestamp() {
            return this.timestamp;
        }

        public final void setTimestamp(String timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public final Builder timestamp(String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final List<LoRaWANGatewayMetadata.Builder> getGateways() {
            List<LoRaWANGatewayMetadata.Builder> result = LoRaWANGatewayMetadataListCopier.copyToBuilder(this.gateways);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGateways(Collection<LoRaWANGatewayMetadata.BuilderImpl> gateways) {
            this.gateways = LoRaWANGatewayMetadataListCopier.copyFromBuilder(gateways);
        }

        @Override
        public final Builder gateways(Collection<LoRaWANGatewayMetadata> gateways) {
            this.gateways = LoRaWANGatewayMetadataListCopier.copy(gateways);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(LoRaWANGatewayMetadata ... gateways) {
            this.gateways(Arrays.asList(gateways));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder gateways(Consumer<LoRaWANGatewayMetadata.Builder> ... gateways) {
            this.gateways(Stream.of(gateways).map(c -> (LoRaWANGatewayMetadata)((LoRaWANGatewayMetadata.Builder)LoRaWANGatewayMetadata.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public LoRaWANDeviceMetadata build() {
            return new LoRaWANDeviceMetadata(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LoRaWANDeviceMetadata> {
        public Builder devEui(String var1);

        public Builder fPort(Integer var1);

        public Builder dataRate(Integer var1);

        public Builder frequency(Integer var1);

        public Builder timestamp(String var1);

        public Builder gateways(Collection<LoRaWANGatewayMetadata> var1);

        public Builder gateways(LoRaWANGatewayMetadata ... var1);

        public Builder gateways(Consumer<LoRaWANGatewayMetadata.Builder> ... var1);
    }
}

