/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse;

public class ListPropertiesIterable
implements SdkIterable<ListPropertiesResponse> {
    private final IoTTwinMakerClient client;
    private final ListPropertiesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPropertiesIterable(IoTTwinMakerClient client, ListPropertiesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPropertiesResponseFetcher();
    }

    public Iterator<ListPropertiesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListPropertiesResponseFetcher
    implements SyncPageFetcher<ListPropertiesResponse> {
        private ListPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(ListPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPropertiesResponse nextPage(ListPropertiesResponse previousPage) {
            if (previousPage == null) {
                return ListPropertiesIterable.this.client.listProperties(ListPropertiesIterable.this.firstRequest);
            }
            return ListPropertiesIterable.this.client.listProperties((ListPropertiesRequest)((Object)ListPropertiesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

