/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesRequest;
import software.amazon.awssdk.services.iottwinmaker.model.ListPropertiesResponse;

public class ListPropertiesPublisher
implements SdkPublisher<ListPropertiesResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final ListPropertiesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListPropertiesPublisher(IoTTwinMakerAsyncClient client, ListPropertiesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListPropertiesPublisher(IoTTwinMakerAsyncClient client, ListPropertiesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListPropertiesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListPropertiesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListPropertiesResponseFetcher
    implements AsyncPageFetcher<ListPropertiesResponse> {
        private ListPropertiesResponseFetcher() {
        }

        public boolean hasNextPage(ListPropertiesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListPropertiesResponse> nextPage(ListPropertiesResponse previousPage) {
            if (previousPage == null) {
                return ListPropertiesPublisher.this.client.listProperties(ListPropertiesPublisher.this.firstRequest);
            }
            return ListPropertiesPublisher.this.client.listProperties((ListPropertiesRequest)((Object)ListPropertiesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

