/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iottwinmaker.IoTTwinMakerAsyncClient;
import software.amazon.awssdk.services.iottwinmaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueRequest;
import software.amazon.awssdk.services.iottwinmaker.model.GetPropertyValueResponse;

public class GetPropertyValuePublisher
implements SdkPublisher<GetPropertyValueResponse> {
    private final IoTTwinMakerAsyncClient client;
    private final GetPropertyValueRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetPropertyValuePublisher(IoTTwinMakerAsyncClient client, GetPropertyValueRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetPropertyValuePublisher(IoTTwinMakerAsyncClient client, GetPropertyValueRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetPropertyValueResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetPropertyValueResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetPropertyValueResponseFetcher
    implements AsyncPageFetcher<GetPropertyValueResponse> {
        private GetPropertyValueResponseFetcher() {
        }

        public boolean hasNextPage(GetPropertyValueResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetPropertyValueResponse> nextPage(GetPropertyValueResponse previousPage) {
            if (previousPage == null) {
                return GetPropertyValuePublisher.this.client.getPropertyValue(GetPropertyValuePublisher.this.firstRequest);
            }
            return GetPropertyValuePublisher.this.client.getPropertyValue((GetPropertyValueRequest)((Object)GetPropertyValuePublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

