/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SyncResourceState {
    INITIALIZING("INITIALIZING"),
    PROCESSING("PROCESSING"),
    DELETED("DELETED"),
    IN_SYNC("IN_SYNC"),
    ERROR("ERROR"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SyncResourceState> VALUE_MAP;
    private final String value;

    private SyncResourceState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SyncResourceState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SyncResourceState> knownValues() {
        EnumSet<SyncResourceState> knownValues = EnumSet.allOf(SyncResourceState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SyncResourceState.class, SyncResourceState::toString);
    }
}

