/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iottwinmaker.model.IotSiteWiseSourceConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.IotTwinMakerSourceConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.S3SourceConfiguration;
import software.amazon.awssdk.services.iottwinmaker.model.SourceType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceConfiguration> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SourceConfiguration.getter(SourceConfiguration::typeAsString)).setter(SourceConfiguration.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<S3SourceConfiguration> S3_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Configuration").getter(SourceConfiguration.getter(SourceConfiguration::s3Configuration)).setter(SourceConfiguration.setter(Builder::s3Configuration)).constructor(S3SourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Configuration").build()}).build();
    private static final SdkField<IotSiteWiseSourceConfiguration> IOT_SITE_WISE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotSiteWiseConfiguration").getter(SourceConfiguration.getter(SourceConfiguration::iotSiteWiseConfiguration)).setter(SourceConfiguration.setter(Builder::iotSiteWiseConfiguration)).constructor(IotSiteWiseSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotSiteWiseConfiguration").build()}).build();
    private static final SdkField<IotTwinMakerSourceConfiguration> IOT_TWIN_MAKER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("iotTwinMakerConfiguration").getter(SourceConfiguration.getter(SourceConfiguration::iotTwinMakerConfiguration)).setter(SourceConfiguration.setter(Builder::iotTwinMakerConfiguration)).constructor(IotTwinMakerSourceConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iotTwinMakerConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, S3_CONFIGURATION_FIELD, IOT_SITE_WISE_CONFIGURATION_FIELD, IOT_TWIN_MAKER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SourceConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final S3SourceConfiguration s3Configuration;
    private final IotSiteWiseSourceConfiguration iotSiteWiseConfiguration;
    private final IotTwinMakerSourceConfiguration iotTwinMakerConfiguration;

    private SourceConfiguration(BuilderImpl builder) {
        this.type = builder.type;
        this.s3Configuration = builder.s3Configuration;
        this.iotSiteWiseConfiguration = builder.iotSiteWiseConfiguration;
        this.iotTwinMakerConfiguration = builder.iotTwinMakerConfiguration;
    }

    public final SourceType type() {
        return SourceType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final S3SourceConfiguration s3Configuration() {
        return this.s3Configuration;
    }

    public final IotSiteWiseSourceConfiguration iotSiteWiseConfiguration() {
        return this.iotSiteWiseConfiguration;
    }

    public final IotTwinMakerSourceConfiguration iotTwinMakerConfiguration() {
        return this.iotTwinMakerConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotSiteWiseConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotTwinMakerConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceConfiguration)) {
            return false;
        }
        SourceConfiguration other = (SourceConfiguration)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.s3Configuration(), other.s3Configuration()) && Objects.equals(this.iotSiteWiseConfiguration(), other.iotSiteWiseConfiguration()) && Objects.equals(this.iotTwinMakerConfiguration(), other.iotTwinMakerConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"SourceConfiguration").add("Type", (Object)this.typeAsString()).add("S3Configuration", (Object)this.s3Configuration()).add("IotSiteWiseConfiguration", (Object)this.iotSiteWiseConfiguration()).add("IotTwinMakerConfiguration", (Object)this.iotTwinMakerConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "s3Configuration": {
                return Optional.ofNullable(clazz.cast(this.s3Configuration()));
            }
            case "iotSiteWiseConfiguration": {
                return Optional.ofNullable(clazz.cast(this.iotSiteWiseConfiguration()));
            }
            case "iotTwinMakerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.iotTwinMakerConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("s3Configuration", S3_CONFIGURATION_FIELD);
        map.put("iotSiteWiseConfiguration", IOT_SITE_WISE_CONFIGURATION_FIELD);
        map.put("iotTwinMakerConfiguration", IOT_TWIN_MAKER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SourceConfiguration, T> g) {
        return obj -> g.apply((SourceConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private S3SourceConfiguration s3Configuration;
        private IotSiteWiseSourceConfiguration iotSiteWiseConfiguration;
        private IotTwinMakerSourceConfiguration iotTwinMakerConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(SourceConfiguration model) {
            this.type(model.type);
            this.s3Configuration(model.s3Configuration);
            this.iotSiteWiseConfiguration(model.iotSiteWiseConfiguration);
            this.iotTwinMakerConfiguration(model.iotTwinMakerConfiguration);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final S3SourceConfiguration.Builder getS3Configuration() {
            return this.s3Configuration != null ? this.s3Configuration.toBuilder() : null;
        }

        public final void setS3Configuration(S3SourceConfiguration.BuilderImpl s3Configuration) {
            this.s3Configuration = s3Configuration != null ? s3Configuration.build() : null;
        }

        @Override
        public final Builder s3Configuration(S3SourceConfiguration s3Configuration) {
            this.s3Configuration = s3Configuration;
            return this;
        }

        public final IotSiteWiseSourceConfiguration.Builder getIotSiteWiseConfiguration() {
            return this.iotSiteWiseConfiguration != null ? this.iotSiteWiseConfiguration.toBuilder() : null;
        }

        public final void setIotSiteWiseConfiguration(IotSiteWiseSourceConfiguration.BuilderImpl iotSiteWiseConfiguration) {
            this.iotSiteWiseConfiguration = iotSiteWiseConfiguration != null ? iotSiteWiseConfiguration.build() : null;
        }

        @Override
        public final Builder iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration iotSiteWiseConfiguration) {
            this.iotSiteWiseConfiguration = iotSiteWiseConfiguration;
            return this;
        }

        public final IotTwinMakerSourceConfiguration.Builder getIotTwinMakerConfiguration() {
            return this.iotTwinMakerConfiguration != null ? this.iotTwinMakerConfiguration.toBuilder() : null;
        }

        public final void setIotTwinMakerConfiguration(IotTwinMakerSourceConfiguration.BuilderImpl iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration != null ? iotTwinMakerConfiguration.build() : null;
        }

        @Override
        public final Builder iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration iotTwinMakerConfiguration) {
            this.iotTwinMakerConfiguration = iotTwinMakerConfiguration;
            return this;
        }

        public SourceConfiguration build() {
            return new SourceConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceConfiguration> {
        public Builder type(String var1);

        public Builder type(SourceType var1);

        public Builder s3Configuration(S3SourceConfiguration var1);

        default public Builder s3Configuration(Consumer<S3SourceConfiguration.Builder> s3Configuration) {
            return this.s3Configuration((S3SourceConfiguration)((S3SourceConfiguration.Builder)S3SourceConfiguration.builder().applyMutation(s3Configuration)).build());
        }

        public Builder iotSiteWiseConfiguration(IotSiteWiseSourceConfiguration var1);

        default public Builder iotSiteWiseConfiguration(Consumer<IotSiteWiseSourceConfiguration.Builder> iotSiteWiseConfiguration) {
            return this.iotSiteWiseConfiguration((IotSiteWiseSourceConfiguration)((IotSiteWiseSourceConfiguration.Builder)IotSiteWiseSourceConfiguration.builder().applyMutation(iotSiteWiseConfiguration)).build());
        }

        public Builder iotTwinMakerConfiguration(IotTwinMakerSourceConfiguration var1);

        default public Builder iotTwinMakerConfiguration(Consumer<IotTwinMakerSourceConfiguration.Builder> iotTwinMakerConfiguration) {
            return this.iotTwinMakerConfiguration((IotTwinMakerSourceConfiguration)((IotTwinMakerSourceConfiguration.Builder)IotTwinMakerSourceConfiguration.builder().applyMutation(iotTwinMakerConfiguration)).build());
        }
    }
}

