/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.EntityPropertyReference;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyValue;
import software.amazon.awssdk.services.iottwinmaker.model.PropertyValuesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PropertyValueEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PropertyValueEntry> {
    private static final SdkField<EntityPropertyReference> ENTITY_PROPERTY_REFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("entityPropertyReference").getter(PropertyValueEntry.getter(PropertyValueEntry::entityPropertyReference)).setter(PropertyValueEntry.setter(Builder::entityPropertyReference)).constructor(EntityPropertyReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityPropertyReference").build()}).build();
    private static final SdkField<List<PropertyValue>> PROPERTY_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("propertyValues").getter(PropertyValueEntry.getter(PropertyValueEntry::propertyValues)).setter(PropertyValueEntry.setter(Builder::propertyValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("propertyValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PropertyValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENTITY_PROPERTY_REFERENCE_FIELD, PROPERTY_VALUES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PropertyValueEntry.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final EntityPropertyReference entityPropertyReference;
    private final List<PropertyValue> propertyValues;

    private PropertyValueEntry(BuilderImpl builder) {
        this.entityPropertyReference = builder.entityPropertyReference;
        this.propertyValues = builder.propertyValues;
    }

    public final EntityPropertyReference entityPropertyReference() {
        return this.entityPropertyReference;
    }

    public final boolean hasPropertyValues() {
        return this.propertyValues != null && !(this.propertyValues instanceof SdkAutoConstructList);
    }

    public final List<PropertyValue> propertyValues() {
        return this.propertyValues;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.entityPropertyReference());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPropertyValues() ? this.propertyValues() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PropertyValueEntry)) {
            return false;
        }
        PropertyValueEntry other = (PropertyValueEntry)obj;
        return Objects.equals(this.entityPropertyReference(), other.entityPropertyReference()) && this.hasPropertyValues() == other.hasPropertyValues() && Objects.equals(this.propertyValues(), other.propertyValues());
    }

    public final String toString() {
        return ToString.builder((String)"PropertyValueEntry").add("EntityPropertyReference", (Object)this.entityPropertyReference()).add("PropertyValues", this.hasPropertyValues() ? this.propertyValues() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "entityPropertyReference": {
                return Optional.ofNullable(clazz.cast(this.entityPropertyReference()));
            }
            case "propertyValues": {
                return Optional.ofNullable(clazz.cast(this.propertyValues()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("entityPropertyReference", ENTITY_PROPERTY_REFERENCE_FIELD);
        map.put("propertyValues", PROPERTY_VALUES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PropertyValueEntry, T> g) {
        return obj -> g.apply((PropertyValueEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private EntityPropertyReference entityPropertyReference;
        private List<PropertyValue> propertyValues = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PropertyValueEntry model) {
            this.entityPropertyReference(model.entityPropertyReference);
            this.propertyValues(model.propertyValues);
        }

        public final EntityPropertyReference.Builder getEntityPropertyReference() {
            return this.entityPropertyReference != null ? this.entityPropertyReference.toBuilder() : null;
        }

        public final void setEntityPropertyReference(EntityPropertyReference.BuilderImpl entityPropertyReference) {
            this.entityPropertyReference = entityPropertyReference != null ? entityPropertyReference.build() : null;
        }

        @Override
        public final Builder entityPropertyReference(EntityPropertyReference entityPropertyReference) {
            this.entityPropertyReference = entityPropertyReference;
            return this;
        }

        public final List<PropertyValue.Builder> getPropertyValues() {
            List<PropertyValue.Builder> result = PropertyValuesCopier.copyToBuilder(this.propertyValues);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPropertyValues(Collection<PropertyValue.BuilderImpl> propertyValues) {
            this.propertyValues = PropertyValuesCopier.copyFromBuilder(propertyValues);
        }

        @Override
        public final Builder propertyValues(Collection<PropertyValue> propertyValues) {
            this.propertyValues = PropertyValuesCopier.copy(propertyValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(PropertyValue ... propertyValues) {
            this.propertyValues(Arrays.asList(propertyValues));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder propertyValues(Consumer<PropertyValue.Builder> ... propertyValues) {
            this.propertyValues(Stream.of(propertyValues).map(c -> (PropertyValue)((PropertyValue.Builder)PropertyValue.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PropertyValueEntry build() {
            return new PropertyValueEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PropertyValueEntry> {
        public Builder entityPropertyReference(EntityPropertyReference var1);

        default public Builder entityPropertyReference(Consumer<EntityPropertyReference.Builder> entityPropertyReference) {
            return this.entityPropertyReference((EntityPropertyReference)((EntityPropertyReference.Builder)EntityPropertyReference.builder().applyMutation(entityPropertyReference)).build());
        }

        public Builder propertyValues(Collection<PropertyValue> var1);

        public Builder propertyValues(PropertyValue ... var1);

        public Builder propertyValues(Consumer<PropertyValue.Builder> ... var1);
    }
}

