/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iottwinmaker.model.IoTTwinMakerResponse;
import software.amazon.awssdk.services.iottwinmaker.model.SceneSummariesCopier;
import software.amazon.awssdk.services.iottwinmaker.model.SceneSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScenesResponse
extends IoTTwinMakerResponse
implements ToCopyableBuilder<Builder, ListScenesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListScenesResponse.getter(ListScenesResponse::nextToken)).setter(ListScenesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SceneSummary>> SCENE_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sceneSummaries").getter(ListScenesResponse.getter(ListScenesResponse::sceneSummaries)).setter(ListScenesResponse.setter(Builder::sceneSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sceneSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SceneSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, SCENE_SUMMARIES_FIELD));
    private final String nextToken;
    private final List<SceneSummary> sceneSummaries;

    private ListScenesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.sceneSummaries = builder.sceneSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSceneSummaries() {
        return this.sceneSummaries != null && !(this.sceneSummaries instanceof SdkAutoConstructList);
    }

    public final List<SceneSummary> sceneSummaries() {
        return this.sceneSummaries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSceneSummaries() ? this.sceneSummaries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScenesResponse)) {
            return false;
        }
        ListScenesResponse other = (ListScenesResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasSceneSummaries() == other.hasSceneSummaries() && Objects.equals(this.sceneSummaries(), other.sceneSummaries());
    }

    public final String toString() {
        return ToString.builder((String)"ListScenesResponse").add("NextToken", (Object)this.nextToken()).add("SceneSummaries", this.hasSceneSummaries() ? this.sceneSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "sceneSummaries": {
                return Optional.ofNullable(clazz.cast(this.sceneSummaries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListScenesResponse, T> g) {
        return obj -> g.apply((ListScenesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTTwinMakerResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<SceneSummary> sceneSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListScenesResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.sceneSummaries(model.sceneSummaries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SceneSummary.Builder> getSceneSummaries() {
            List<SceneSummary.Builder> result = SceneSummariesCopier.copyToBuilder(this.sceneSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSceneSummaries(Collection<SceneSummary.BuilderImpl> sceneSummaries) {
            this.sceneSummaries = SceneSummariesCopier.copyFromBuilder(sceneSummaries);
        }

        @Override
        @Transient
        public final Builder sceneSummaries(Collection<SceneSummary> sceneSummaries) {
            this.sceneSummaries = SceneSummariesCopier.copy(sceneSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sceneSummaries(SceneSummary ... sceneSummaries) {
            this.sceneSummaries(Arrays.asList(sceneSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder sceneSummaries(Consumer<SceneSummary.Builder> ... sceneSummaries) {
            this.sceneSummaries(Stream.of(sceneSummaries).map(c -> (SceneSummary)((SceneSummary.Builder)SceneSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListScenesResponse build() {
            return new ListScenesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends IoTTwinMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScenesResponse> {
        public Builder nextToken(String var1);

        public Builder sceneSummaries(Collection<SceneSummary> var1);

        public Builder sceneSummaries(SceneSummary ... var1);

        public Builder sceneSummaries(Consumer<SceneSummary.Builder> ... var1);
    }
}

