/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSceneRequest extends IoTTwinMakerRequest implements
        ToCopyableBuilder<UpdateSceneRequest.Builder, UpdateSceneRequest> {
    private static final SdkField<List<String>> CAPABILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("capabilities")
            .getter(getter(UpdateSceneRequest::capabilities))
            .setter(setter(Builder::capabilities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> CONTENT_LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contentLocation").getter(getter(UpdateSceneRequest::contentLocation))
            .setter(setter(Builder::contentLocation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contentLocation").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateSceneRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> SCENE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sceneId").getter(getter(UpdateSceneRequest::sceneId)).setter(setter(Builder::sceneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sceneId").build()).build();

    private static final SdkField<String> WORKSPACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workspaceId").getter(getter(UpdateSceneRequest::workspaceId)).setter(setter(Builder::workspaceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workspaceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPABILITIES_FIELD,
            CONTENT_LOCATION_FIELD, DESCRIPTION_FIELD, SCENE_ID_FIELD, WORKSPACE_ID_FIELD));

    private final List<String> capabilities;

    private final String contentLocation;

    private final String description;

    private final String sceneId;

    private final String workspaceId;

    private UpdateSceneRequest(BuilderImpl builder) {
        super(builder);
        this.capabilities = builder.capabilities;
        this.contentLocation = builder.contentLocation;
        this.description = builder.description;
        this.sceneId = builder.sceneId;
        this.workspaceId = builder.workspaceId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Capabilities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCapabilities() {
        return capabilities != null && !(capabilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of capabilities that the scene uses to render.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCapabilities} method.
     * </p>
     * 
     * @return A list of capabilities that the scene uses to render.
     */
    public final List<String> capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The relative path that specifies the location of the content definition file.
     * </p>
     * 
     * @return The relative path that specifies the location of the content definition file.
     */
    public final String contentLocation() {
        return contentLocation;
    }

    /**
     * <p>
     * The description of this scene.
     * </p>
     * 
     * @return The description of this scene.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The ID of the scene.
     * </p>
     * 
     * @return The ID of the scene.
     */
    public final String sceneId() {
        return sceneId;
    }

    /**
     * <p>
     * The ID of the workspace that contains the scene.
     * </p>
     * 
     * @return The ID of the workspace that contains the scene.
     */
    public final String workspaceId() {
        return workspaceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCapabilities() ? capabilities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(contentLocation());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sceneId());
        hashCode = 31 * hashCode + Objects.hashCode(workspaceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSceneRequest)) {
            return false;
        }
        UpdateSceneRequest other = (UpdateSceneRequest) obj;
        return hasCapabilities() == other.hasCapabilities() && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(contentLocation(), other.contentLocation())
                && Objects.equals(description(), other.description()) && Objects.equals(sceneId(), other.sceneId())
                && Objects.equals(workspaceId(), other.workspaceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSceneRequest").add("Capabilities", hasCapabilities() ? capabilities() : null)
                .add("ContentLocation", contentLocation()).add("Description", description()).add("SceneId", sceneId())
                .add("WorkspaceId", workspaceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "contentLocation":
            return Optional.ofNullable(clazz.cast(contentLocation()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sceneId":
            return Optional.ofNullable(clazz.cast(sceneId()));
        case "workspaceId":
            return Optional.ofNullable(clazz.cast(workspaceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSceneRequest, T> g) {
        return obj -> g.apply((UpdateSceneRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends IoTTwinMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSceneRequest> {
        /**
         * <p>
         * A list of capabilities that the scene uses to render.
         * </p>
         * 
         * @param capabilities
         *        A list of capabilities that the scene uses to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(Collection<String> capabilities);

        /**
         * <p>
         * A list of capabilities that the scene uses to render.
         * </p>
         * 
         * @param capabilities
         *        A list of capabilities that the scene uses to render.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(String... capabilities);

        /**
         * <p>
         * The relative path that specifies the location of the content definition file.
         * </p>
         * 
         * @param contentLocation
         *        The relative path that specifies the location of the content definition file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contentLocation(String contentLocation);

        /**
         * <p>
         * The description of this scene.
         * </p>
         * 
         * @param description
         *        The description of this scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The ID of the scene.
         * </p>
         * 
         * @param sceneId
         *        The ID of the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sceneId(String sceneId);

        /**
         * <p>
         * The ID of the workspace that contains the scene.
         * </p>
         * 
         * @param workspaceId
         *        The ID of the workspace that contains the scene.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workspaceId(String workspaceId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends IoTTwinMakerRequest.BuilderImpl implements Builder {
        private List<String> capabilities = DefaultSdkAutoConstructList.getInstance();

        private String contentLocation;

        private String description;

        private String sceneId;

        private String workspaceId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSceneRequest model) {
            super(model);
            capabilities(model.capabilities);
            contentLocation(model.contentLocation);
            description(model.description);
            sceneId(model.sceneId);
            workspaceId(model.workspaceId);
        }

        public final Collection<String> getCapabilities() {
            if (capabilities instanceof SdkAutoConstructList) {
                return null;
            }
            return capabilities;
        }

        public final void setCapabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
        }

        @Override
        @Transient
        public final Builder capabilities(Collection<String> capabilities) {
            this.capabilities = SceneCapabilitiesCopier.copy(capabilities);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder capabilities(String... capabilities) {
            capabilities(Arrays.asList(capabilities));
            return this;
        }

        public final String getContentLocation() {
            return contentLocation;
        }

        public final void setContentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
        }

        @Override
        @Transient
        public final Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getSceneId() {
            return sceneId;
        }

        public final void setSceneId(String sceneId) {
            this.sceneId = sceneId;
        }

        @Override
        @Transient
        public final Builder sceneId(String sceneId) {
            this.sceneId = sceneId;
            return this;
        }

        public final String getWorkspaceId() {
            return workspaceId;
        }

        public final void setWorkspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
        }

        @Override
        @Transient
        public final Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSceneRequest build() {
            return new UpdateSceneRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
