/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The parent entity update request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ParentEntityUpdateRequest implements SdkPojo, Serializable,
        ToCopyableBuilder<ParentEntityUpdateRequest.Builder, ParentEntityUpdateRequest> {
    private static final SdkField<String> PARENT_ENTITY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("parentEntityId").getter(getter(ParentEntityUpdateRequest::parentEntityId))
            .setter(setter(Builder::parentEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parentEntityId").build()).build();

    private static final SdkField<String> UPDATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updateType").getter(getter(ParentEntityUpdateRequest::updateTypeAsString))
            .setter(setter(Builder::updateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARENT_ENTITY_ID_FIELD,
            UPDATE_TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parentEntityId;

    private final String updateType;

    private ParentEntityUpdateRequest(BuilderImpl builder) {
        this.parentEntityId = builder.parentEntityId;
        this.updateType = builder.updateType;
    }

    /**
     * <p>
     * The ID of the parent entity.
     * </p>
     * 
     * @return The ID of the parent entity.
     */
    public final String parentEntityId() {
        return parentEntityId;
    }

    /**
     * <p>
     * The type of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link ParentEntityUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of the update.
     * @see ParentEntityUpdateType
     */
    public final ParentEntityUpdateType updateType() {
        return ParentEntityUpdateType.fromValue(updateType);
    }

    /**
     * <p>
     * The type of the update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateType} will
     * return {@link ParentEntityUpdateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #updateTypeAsString}.
     * </p>
     * 
     * @return The type of the update.
     * @see ParentEntityUpdateType
     */
    public final String updateTypeAsString() {
        return updateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parentEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(updateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParentEntityUpdateRequest)) {
            return false;
        }
        ParentEntityUpdateRequest other = (ParentEntityUpdateRequest) obj;
        return Objects.equals(parentEntityId(), other.parentEntityId())
                && Objects.equals(updateTypeAsString(), other.updateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ParentEntityUpdateRequest").add("ParentEntityId", parentEntityId())
                .add("UpdateType", updateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "parentEntityId":
            return Optional.ofNullable(clazz.cast(parentEntityId()));
        case "updateType":
            return Optional.ofNullable(clazz.cast(updateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ParentEntityUpdateRequest, T> g) {
        return obj -> g.apply((ParentEntityUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ParentEntityUpdateRequest> {
        /**
         * <p>
         * The ID of the parent entity.
         * </p>
         * 
         * @param parentEntityId
         *        The ID of the parent entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentEntityId(String parentEntityId);

        /**
         * <p>
         * The type of the update.
         * </p>
         * 
         * @param updateType
         *        The type of the update.
         * @see ParentEntityUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParentEntityUpdateType
         */
        Builder updateType(String updateType);

        /**
         * <p>
         * The type of the update.
         * </p>
         * 
         * @param updateType
         *        The type of the update.
         * @see ParentEntityUpdateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParentEntityUpdateType
         */
        Builder updateType(ParentEntityUpdateType updateType);
    }

    static final class BuilderImpl implements Builder {
        private String parentEntityId;

        private String updateType;

        private BuilderImpl() {
        }

        private BuilderImpl(ParentEntityUpdateRequest model) {
            parentEntityId(model.parentEntityId);
            updateType(model.updateType);
        }

        public final String getParentEntityId() {
            return parentEntityId;
        }

        public final void setParentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
        }

        @Override
        @Transient
        public final Builder parentEntityId(String parentEntityId) {
            this.parentEntityId = parentEntityId;
            return this;
        }

        public final String getUpdateType() {
            return updateType;
        }

        public final void setUpdateType(String updateType) {
            this.updateType = updateType;
        }

        @Override
        @Transient
        public final Builder updateType(String updateType) {
            this.updateType = updateType;
            return this;
        }

        @Override
        @Transient
        public final Builder updateType(ParentEntityUpdateType updateType) {
            this.updateType(updateType == null ? null : updateType.toString());
            return this;
        }

        @Override
        public ParentEntityUpdateRequest build() {
            return new ParentEntityUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
