/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that filters items in a list of component types.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListComponentTypesFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ListComponentTypesFilter.Builder, ListComponentTypesFilter> {
    private static final SdkField<String> EXTENDS_FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("extendsFrom").getter(getter(ListComponentTypesFilter::extendsFrom)).setter(setter(Builder::extendsFrom))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extendsFrom").build()).build();

    private static final SdkField<Boolean> IS_ABSTRACT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("isAbstract").getter(getter(ListComponentTypesFilter::isAbstract)).setter(setter(Builder::isAbstract))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isAbstract").build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("namespace").getter(getter(ListComponentTypesFilter::namespace)).setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTENDS_FROM_FIELD,
            IS_ABSTRACT_FIELD, NAMESPACE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String extendsFrom;

    private final Boolean isAbstract;

    private final String namespace;

    private ListComponentTypesFilter(BuilderImpl builder) {
        this.extendsFrom = builder.extendsFrom;
        this.isAbstract = builder.isAbstract;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The component type that the component types in the list extend.
     * </p>
     * 
     * @return The component type that the component types in the list extend.
     */
    public final String extendsFrom() {
        return extendsFrom;
    }

    /**
     * <p>
     * A Boolean value that specifies whether the component types in the list are abstract.
     * </p>
     * 
     * @return A Boolean value that specifies whether the component types in the list are abstract.
     */
    public final Boolean isAbstract() {
        return isAbstract;
    }

    /**
     * <p>
     * The namespace to which the component types in the list belong.
     * </p>
     * 
     * @return The namespace to which the component types in the list belong.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(extendsFrom());
        hashCode = 31 * hashCode + Objects.hashCode(isAbstract());
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListComponentTypesFilter)) {
            return false;
        }
        ListComponentTypesFilter other = (ListComponentTypesFilter) obj;
        return Objects.equals(extendsFrom(), other.extendsFrom()) && Objects.equals(isAbstract(), other.isAbstract())
                && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListComponentTypesFilter").add("ExtendsFrom", extendsFrom()).add("IsAbstract", isAbstract())
                .add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "extendsFrom":
            return Optional.ofNullable(clazz.cast(extendsFrom()));
        case "isAbstract":
            return Optional.ofNullable(clazz.cast(isAbstract()));
        case "namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListComponentTypesFilter, T> g) {
        return obj -> g.apply((ListComponentTypesFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListComponentTypesFilter> {
        /**
         * <p>
         * The component type that the component types in the list extend.
         * </p>
         * 
         * @param extendsFrom
         *        The component type that the component types in the list extend.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder extendsFrom(String extendsFrom);

        /**
         * <p>
         * A Boolean value that specifies whether the component types in the list are abstract.
         * </p>
         * 
         * @param isAbstract
         *        A Boolean value that specifies whether the component types in the list are abstract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isAbstract(Boolean isAbstract);

        /**
         * <p>
         * The namespace to which the component types in the list belong.
         * </p>
         * 
         * @param namespace
         *        The namespace to which the component types in the list belong.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);
    }

    static final class BuilderImpl implements Builder {
        private String extendsFrom;

        private Boolean isAbstract;

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(ListComponentTypesFilter model) {
            extendsFrom(model.extendsFrom);
            isAbstract(model.isAbstract);
            namespace(model.namespace);
        }

        public final String getExtendsFrom() {
            return extendsFrom;
        }

        public final void setExtendsFrom(String extendsFrom) {
            this.extendsFrom = extendsFrom;
        }

        @Override
        @Transient
        public final Builder extendsFrom(String extendsFrom) {
            this.extendsFrom = extendsFrom;
            return this;
        }

        public final Boolean getIsAbstract() {
            return isAbstract;
        }

        public final void setIsAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
        }

        @Override
        @Transient
        public final Builder isAbstract(Boolean isAbstract) {
            this.isAbstract = isAbstract;
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public ListComponentTypesFilter build() {
            return new ListComponentTypesFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
