/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.iottwinmaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that specifies a value for a property.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataValue implements SdkPojo, Serializable, ToCopyableBuilder<DataValue.Builder, DataValue> {
    private static final SdkField<Boolean> BOOLEAN_VALUE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("booleanValue").getter(getter(DataValue::booleanValue)).setter(setter(Builder::booleanValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("booleanValue").build()).build();

    private static final SdkField<Double> DOUBLE_VALUE_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("doubleValue").getter(getter(DataValue::doubleValue)).setter(setter(Builder::doubleValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("doubleValue").build()).build();

    private static final SdkField<String> EXPRESSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("expression").getter(getter(DataValue::expression)).setter(setter(Builder::expression))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expression").build()).build();

    private static final SdkField<Integer> INTEGER_VALUE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("integerValue").getter(getter(DataValue::integerValue)).setter(setter(Builder::integerValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("integerValue").build()).build();

    private static final SdkField<List<DataValue>> LIST_VALUE_FIELD = SdkField
            .<List<DataValue>> builder(MarshallingType.LIST)
            .memberName("listValue")
            .getter(getter(DataValue::listValue))
            .setter(setter(Builder::listValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("listValue").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Long> LONG_VALUE_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("longValue")
            .getter(getter(DataValue::longValue)).setter(setter(Builder::longValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("longValue").build()).build();

    private static final SdkField<Map<String, DataValue>> MAP_VALUE_FIELD = SdkField
            .<Map<String, DataValue>> builder(MarshallingType.MAP)
            .memberName("mapValue")
            .getter(getter(DataValue::mapValue))
            .setter(setter(Builder::mapValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mapValue").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<DataValue> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataValue::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<RelationshipValue> RELATIONSHIP_VALUE_FIELD = SdkField
            .<RelationshipValue> builder(MarshallingType.SDK_POJO).memberName("relationshipValue")
            .getter(getter(DataValue::relationshipValue)).setter(setter(Builder::relationshipValue))
            .constructor(RelationshipValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationshipValue").build()).build();

    private static final SdkField<String> STRING_VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stringValue").getter(getter(DataValue::stringValue)).setter(setter(Builder::stringValue))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stringValue").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BOOLEAN_VALUE_FIELD,
            DOUBLE_VALUE_FIELD, EXPRESSION_FIELD, INTEGER_VALUE_FIELD, LIST_VALUE_FIELD, LONG_VALUE_FIELD, MAP_VALUE_FIELD,
            RELATIONSHIP_VALUE_FIELD, STRING_VALUE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean booleanValue;

    private final Double doubleValue;

    private final String expression;

    private final Integer integerValue;

    private final List<DataValue> listValue;

    private final Long longValue;

    private final Map<String, DataValue> mapValue;

    private final RelationshipValue relationshipValue;

    private final String stringValue;

    private DataValue(BuilderImpl builder) {
        this.booleanValue = builder.booleanValue;
        this.doubleValue = builder.doubleValue;
        this.expression = builder.expression;
        this.integerValue = builder.integerValue;
        this.listValue = builder.listValue;
        this.longValue = builder.longValue;
        this.mapValue = builder.mapValue;
        this.relationshipValue = builder.relationshipValue;
        this.stringValue = builder.stringValue;
    }

    /**
     * <p>
     * A Boolean value.
     * </p>
     * 
     * @return A Boolean value.
     */
    public final Boolean booleanValue() {
        return booleanValue;
    }

    /**
     * <p>
     * A double value.
     * </p>
     * 
     * @return A double value.
     */
    public final Double doubleValue() {
        return doubleValue;
    }

    /**
     * <p>
     * An expression that produces the value.
     * </p>
     * 
     * @return An expression that produces the value.
     */
    public final String expression() {
        return expression;
    }

    /**
     * <p>
     * An integer value.
     * </p>
     * 
     * @return An integer value.
     */
    public final Integer integerValue() {
        return integerValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the ListValue property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasListValue() {
        return listValue != null && !(listValue instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of multiple values.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasListValue} method.
     * </p>
     * 
     * @return A list of multiple values.
     */
    public final List<DataValue> listValue() {
        return listValue;
    }

    /**
     * <p>
     * A long value.
     * </p>
     * 
     * @return A long value.
     */
    public final Long longValue() {
        return longValue;
    }

    /**
     * For responses, this returns true if the service returned a value for the MapValue property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasMapValue() {
        return mapValue != null && !(mapValue instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * An object that maps strings to multiple <code>DataValue</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMapValue} method.
     * </p>
     * 
     * @return An object that maps strings to multiple <code>DataValue</code> objects.
     */
    public final Map<String, DataValue> mapValue() {
        return mapValue;
    }

    /**
     * <p>
     * A value that relates a component to another component.
     * </p>
     * 
     * @return A value that relates a component to another component.
     */
    public final RelationshipValue relationshipValue() {
        return relationshipValue;
    }

    /**
     * <p>
     * A string value.
     * </p>
     * 
     * @return A string value.
     */
    public final String stringValue() {
        return stringValue;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(booleanValue());
        hashCode = 31 * hashCode + Objects.hashCode(doubleValue());
        hashCode = 31 * hashCode + Objects.hashCode(expression());
        hashCode = 31 * hashCode + Objects.hashCode(integerValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasListValue() ? listValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(longValue());
        hashCode = 31 * hashCode + Objects.hashCode(hasMapValue() ? mapValue() : null);
        hashCode = 31 * hashCode + Objects.hashCode(relationshipValue());
        hashCode = 31 * hashCode + Objects.hashCode(stringValue());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataValue)) {
            return false;
        }
        DataValue other = (DataValue) obj;
        return Objects.equals(booleanValue(), other.booleanValue()) && Objects.equals(doubleValue(), other.doubleValue())
                && Objects.equals(expression(), other.expression()) && Objects.equals(integerValue(), other.integerValue())
                && hasListValue() == other.hasListValue() && Objects.equals(listValue(), other.listValue())
                && Objects.equals(longValue(), other.longValue()) && hasMapValue() == other.hasMapValue()
                && Objects.equals(mapValue(), other.mapValue()) && Objects.equals(relationshipValue(), other.relationshipValue())
                && Objects.equals(stringValue(), other.stringValue());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataValue").add("BooleanValue", booleanValue()).add("DoubleValue", doubleValue())
                .add("Expression", expression()).add("IntegerValue", integerValue())
                .add("ListValue", hasListValue() ? listValue() : null).add("LongValue", longValue())
                .add("MapValue", hasMapValue() ? mapValue() : null).add("RelationshipValue", relationshipValue())
                .add("StringValue", stringValue()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "booleanValue":
            return Optional.ofNullable(clazz.cast(booleanValue()));
        case "doubleValue":
            return Optional.ofNullable(clazz.cast(doubleValue()));
        case "expression":
            return Optional.ofNullable(clazz.cast(expression()));
        case "integerValue":
            return Optional.ofNullable(clazz.cast(integerValue()));
        case "listValue":
            return Optional.ofNullable(clazz.cast(listValue()));
        case "longValue":
            return Optional.ofNullable(clazz.cast(longValue()));
        case "mapValue":
            return Optional.ofNullable(clazz.cast(mapValue()));
        case "relationshipValue":
            return Optional.ofNullable(clazz.cast(relationshipValue()));
        case "stringValue":
            return Optional.ofNullable(clazz.cast(stringValue()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataValue, T> g) {
        return obj -> g.apply((DataValue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataValue> {
        /**
         * <p>
         * A Boolean value.
         * </p>
         * 
         * @param booleanValue
         *        A Boolean value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder booleanValue(Boolean booleanValue);

        /**
         * <p>
         * A double value.
         * </p>
         * 
         * @param doubleValue
         *        A double value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleValue(Double doubleValue);

        /**
         * <p>
         * An expression that produces the value.
         * </p>
         * 
         * @param expression
         *        An expression that produces the value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expression(String expression);

        /**
         * <p>
         * An integer value.
         * </p>
         * 
         * @param integerValue
         *        An integer value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder integerValue(Integer integerValue);

        /**
         * <p>
         * A list of multiple values.
         * </p>
         * 
         * @param listValue
         *        A list of multiple values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listValue(Collection<DataValue> listValue);

        /**
         * <p>
         * A list of multiple values.
         * </p>
         * 
         * @param listValue
         *        A list of multiple values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder listValue(DataValue... listValue);

        /**
         * <p>
         * A list of multiple values.
         * </p>
         * This is a convenience that creates an instance of the {@link List<DataValue>.Builder} avoiding the need to
         * create one manually via {@link List<DataValue>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<DataValue>.Builder#build()} is called immediately and its
         * result is passed to {@link #listValue(List<DataValue>)}.
         * 
         * @param listValue
         *        a consumer that will call methods on {@link List<DataValue>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #listValue(List<DataValue>)
         */
        Builder listValue(Consumer<Builder>... listValue);

        /**
         * <p>
         * A long value.
         * </p>
         * 
         * @param longValue
         *        A long value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder longValue(Long longValue);

        /**
         * <p>
         * An object that maps strings to multiple <code>DataValue</code> objects.
         * </p>
         * 
         * @param mapValue
         *        An object that maps strings to multiple <code>DataValue</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mapValue(Map<String, DataValue> mapValue);

        /**
         * <p>
         * A value that relates a component to another component.
         * </p>
         * 
         * @param relationshipValue
         *        A value that relates a component to another component.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relationshipValue(RelationshipValue relationshipValue);

        /**
         * <p>
         * A value that relates a component to another component.
         * </p>
         * This is a convenience that creates an instance of the {@link RelationshipValue.Builder} avoiding the need to
         * create one manually via {@link RelationshipValue#builder()}.
         *
         * When the {@link Consumer} completes, {@link RelationshipValue.Builder#build()} is called immediately and its
         * result is passed to {@link #relationshipValue(RelationshipValue)}.
         * 
         * @param relationshipValue
         *        a consumer that will call methods on {@link RelationshipValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relationshipValue(RelationshipValue)
         */
        default Builder relationshipValue(Consumer<RelationshipValue.Builder> relationshipValue) {
            return relationshipValue(RelationshipValue.builder().applyMutation(relationshipValue).build());
        }

        /**
         * <p>
         * A string value.
         * </p>
         * 
         * @param stringValue
         *        A string value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stringValue(String stringValue);
    }

    static final class BuilderImpl implements Builder {
        private Boolean booleanValue;

        private Double doubleValue;

        private String expression;

        private Integer integerValue;

        private List<DataValue> listValue = DefaultSdkAutoConstructList.getInstance();

        private Long longValue;

        private Map<String, DataValue> mapValue = DefaultSdkAutoConstructMap.getInstance();

        private RelationshipValue relationshipValue;

        private String stringValue;

        private BuilderImpl() {
        }

        private BuilderImpl(DataValue model) {
            booleanValue(model.booleanValue);
            doubleValue(model.doubleValue);
            expression(model.expression);
            integerValue(model.integerValue);
            listValue(model.listValue);
            longValue(model.longValue);
            mapValue(model.mapValue);
            relationshipValue(model.relationshipValue);
            stringValue(model.stringValue);
        }

        public final Boolean getBooleanValue() {
            return booleanValue;
        }

        public final void setBooleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
        }

        @Override
        @Transient
        public final Builder booleanValue(Boolean booleanValue) {
            this.booleanValue = booleanValue;
            return this;
        }

        public final Double getDoubleValue() {
            return doubleValue;
        }

        public final void setDoubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
        }

        @Override
        @Transient
        public final Builder doubleValue(Double doubleValue) {
            this.doubleValue = doubleValue;
            return this;
        }

        public final String getExpression() {
            return expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        @Transient
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final Integer getIntegerValue() {
            return integerValue;
        }

        public final void setIntegerValue(Integer integerValue) {
            this.integerValue = integerValue;
        }

        @Override
        @Transient
        public final Builder integerValue(Integer integerValue) {
            this.integerValue = integerValue;
            return this;
        }

        public final List<Builder> getListValue() {
            List<Builder> result = DataValueListCopier.copyToBuilder(this.listValue);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setListValue(Collection<BuilderImpl> listValue) {
            this.listValue = DataValueListCopier.copyFromBuilder(listValue);
        }

        @Override
        @Transient
        public final Builder listValue(Collection<DataValue> listValue) {
            this.listValue = DataValueListCopier.copy(listValue);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listValue(DataValue... listValue) {
            listValue(Arrays.asList(listValue));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder listValue(Consumer<Builder>... listValue) {
            listValue(Stream.of(listValue).map(c -> DataValue.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Long getLongValue() {
            return longValue;
        }

        public final void setLongValue(Long longValue) {
            this.longValue = longValue;
        }

        @Override
        @Transient
        public final Builder longValue(Long longValue) {
            this.longValue = longValue;
            return this;
        }

        public final Map<String, Builder> getMapValue() {
            Map<String, Builder> result = DataValueMapCopier.copyToBuilder(this.mapValue);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setMapValue(Map<String, BuilderImpl> mapValue) {
            this.mapValue = DataValueMapCopier.copyFromBuilder(mapValue);
        }

        @Override
        @Transient
        public final Builder mapValue(Map<String, DataValue> mapValue) {
            this.mapValue = DataValueMapCopier.copy(mapValue);
            return this;
        }

        public final RelationshipValue.Builder getRelationshipValue() {
            return relationshipValue != null ? relationshipValue.toBuilder() : null;
        }

        public final void setRelationshipValue(RelationshipValue.BuilderImpl relationshipValue) {
            this.relationshipValue = relationshipValue != null ? relationshipValue.build() : null;
        }

        @Override
        @Transient
        public final Builder relationshipValue(RelationshipValue relationshipValue) {
            this.relationshipValue = relationshipValue;
            return this;
        }

        public final String getStringValue() {
            return stringValue;
        }

        public final void setStringValue(String stringValue) {
            this.stringValue = stringValue;
        }

        @Override
        @Transient
        public final Builder stringValue(String stringValue) {
            this.stringValue = stringValue;
            return this;
        }

        @Override
        public DataValue build() {
            return new DataValue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
