/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ComputationModelType {
    ANOMALY_DETECTION("ANOMALY_DETECTION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ComputationModelType> VALUE_MAP;
    private final String value;

    private ComputationModelType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ComputationModelType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ComputationModelType> knownValues() {
        EnumSet<ComputationModelType> knownValues = EnumSet.allOf(ComputationModelType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ComputationModelType.class, ComputationModelType::toString);
    }
}

