/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.InterfaceRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListInterfaceRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListInterfaceRelationshipsResponse;

public class ListInterfaceRelationshipsIterable
implements SdkIterable<ListInterfaceRelationshipsResponse> {
    private final IoTSiteWiseClient client;
    private final ListInterfaceRelationshipsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInterfaceRelationshipsIterable(IoTSiteWiseClient client, ListInterfaceRelationshipsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInterfaceRelationshipsResponseFetcher();
    }

    public Iterator<ListInterfaceRelationshipsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InterfaceRelationshipSummary> interfaceRelationshipSummaries() {
        Function<ListInterfaceRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.interfaceRelationshipSummaries() != null) {
                return response.interfaceRelationshipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInterfaceRelationshipsResponseFetcher
    implements SyncPageFetcher<ListInterfaceRelationshipsResponse> {
        private ListInterfaceRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListInterfaceRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInterfaceRelationshipsResponse nextPage(ListInterfaceRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListInterfaceRelationshipsIterable.this.client.listInterfaceRelationships(ListInterfaceRelationshipsIterable.this.firstRequest);
            }
            return ListInterfaceRelationshipsIterable.this.client.listInterfaceRelationships((ListInterfaceRelationshipsRequest)((Object)ListInterfaceRelationshipsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

