/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelsResponse;

public class ListComputationModelsPublisher
implements SdkPublisher<ListComputationModelsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListComputationModelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListComputationModelsPublisher(IoTSiteWiseAsyncClient client, ListComputationModelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListComputationModelsPublisher(IoTSiteWiseAsyncClient client, ListComputationModelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListComputationModelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListComputationModelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ComputationModelSummary> computationModelSummaries() {
        Function<ListComputationModelsResponse, Iterator> getIterator = response -> {
            if (response != null && response.computationModelSummaries() != null) {
                return response.computationModelSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListComputationModelsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListComputationModelsResponseFetcher
    implements AsyncPageFetcher<ListComputationModelsResponse> {
        private ListComputationModelsResponseFetcher() {
        }

        public boolean hasNextPage(ListComputationModelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListComputationModelsResponse> nextPage(ListComputationModelsResponse previousPage) {
            if (previousPage == null) {
                return ListComputationModelsPublisher.this.client.listComputationModels(ListComputationModelsPublisher.this.firstRequest);
            }
            return ListComputationModelsPublisher.this.client.listComputationModels((ListComputationModelsRequest)((Object)ListComputationModelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

