/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.iotsitewise.model.ExecutionDetailsCopier;
import software.amazon.awssdk.services.iotsitewise.model.ExecutionResultCopier;
import software.amazon.awssdk.services.iotsitewise.model.ExecutionStatus;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.services.iotsitewise.model.ResolveTo;
import software.amazon.awssdk.services.iotsitewise.model.TargetResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeExecutionResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeExecutionResponse> {
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionId)).setter(DescribeExecutionResponse.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> ACTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionType").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::actionType)).setter(DescribeExecutionResponse.setter(Builder::actionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionType").build()}).build();
    private static final SdkField<TargetResource> TARGET_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("targetResource").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::targetResource)).setter(DescribeExecutionResponse.setter(Builder::targetResource)).constructor(TargetResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResource").build()}).build();
    private static final SdkField<String> TARGET_RESOURCE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetResourceVersion").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::targetResourceVersion)).setter(DescribeExecutionResponse.setter(Builder::targetResourceVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetResourceVersion").build()}).build();
    private static final SdkField<ResolveTo> RESOLVE_TO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("resolveTo").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::resolveTo)).setter(DescribeExecutionResponse.setter(Builder::resolveTo)).constructor(ResolveTo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolveTo").build()}).build();
    private static final SdkField<Instant> EXECUTION_START_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionStartTime").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionStartTime)).setter(DescribeExecutionResponse.setter(Builder::executionStartTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStartTime").build()}).build();
    private static final SdkField<Instant> EXECUTION_END_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("executionEndTime").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionEndTime)).setter(DescribeExecutionResponse.setter(Builder::executionEndTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEndTime").build()}).build();
    private static final SdkField<ExecutionStatus> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionStatus").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionStatus)).setter(DescribeExecutionResponse.setter(Builder::executionStatus)).constructor(ExecutionStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<Map<String, String>> EXECUTION_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("executionResult").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionResult)).setter(DescribeExecutionResponse.setter(Builder::executionResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionResult").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> EXECUTION_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("executionDetails").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionDetails)).setter(DescribeExecutionResponse.setter(Builder::executionDetails)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionDetails").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> EXECUTION_ENTITY_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionEntityVersion").getter(DescribeExecutionResponse.getter(DescribeExecutionResponse::executionEntityVersion)).setter(DescribeExecutionResponse.setter(Builder::executionEntityVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionEntityVersion").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ID_FIELD, ACTION_TYPE_FIELD, TARGET_RESOURCE_FIELD, TARGET_RESOURCE_VERSION_FIELD, RESOLVE_TO_FIELD, EXECUTION_START_TIME_FIELD, EXECUTION_END_TIME_FIELD, EXECUTION_STATUS_FIELD, EXECUTION_RESULT_FIELD, EXECUTION_DETAILS_FIELD, EXECUTION_ENTITY_VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeExecutionResponse.memberNameToFieldInitializer();
    private final String executionId;
    private final String actionType;
    private final TargetResource targetResource;
    private final String targetResourceVersion;
    private final ResolveTo resolveTo;
    private final Instant executionStartTime;
    private final Instant executionEndTime;
    private final ExecutionStatus executionStatus;
    private final Map<String, String> executionResult;
    private final Map<String, String> executionDetails;
    private final String executionEntityVersion;

    private DescribeExecutionResponse(BuilderImpl builder) {
        super(builder);
        this.executionId = builder.executionId;
        this.actionType = builder.actionType;
        this.targetResource = builder.targetResource;
        this.targetResourceVersion = builder.targetResourceVersion;
        this.resolveTo = builder.resolveTo;
        this.executionStartTime = builder.executionStartTime;
        this.executionEndTime = builder.executionEndTime;
        this.executionStatus = builder.executionStatus;
        this.executionResult = builder.executionResult;
        this.executionDetails = builder.executionDetails;
        this.executionEntityVersion = builder.executionEntityVersion;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String actionType() {
        return this.actionType;
    }

    public final TargetResource targetResource() {
        return this.targetResource;
    }

    public final String targetResourceVersion() {
        return this.targetResourceVersion;
    }

    public final ResolveTo resolveTo() {
        return this.resolveTo;
    }

    public final Instant executionStartTime() {
        return this.executionStartTime;
    }

    public final Instant executionEndTime() {
        return this.executionEndTime;
    }

    public final ExecutionStatus executionStatus() {
        return this.executionStatus;
    }

    public final boolean hasExecutionResult() {
        return this.executionResult != null && !(this.executionResult instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> executionResult() {
        return this.executionResult;
    }

    public final boolean hasExecutionDetails() {
        return this.executionDetails != null && !(this.executionDetails instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> executionDetails() {
        return this.executionDetails;
    }

    public final String executionEntityVersion() {
        return this.executionEntityVersion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionType());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetResourceVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.resolveTo());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStartTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEndTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionResult() ? this.executionResult() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExecutionDetails() ? this.executionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.executionEntityVersion());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeExecutionResponse)) {
            return false;
        }
        DescribeExecutionResponse other = (DescribeExecutionResponse)((Object)obj);
        return Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.actionType(), other.actionType()) && Objects.equals(this.targetResource(), other.targetResource()) && Objects.equals(this.targetResourceVersion(), other.targetResourceVersion()) && Objects.equals(this.resolveTo(), other.resolveTo()) && Objects.equals(this.executionStartTime(), other.executionStartTime()) && Objects.equals(this.executionEndTime(), other.executionEndTime()) && Objects.equals(this.executionStatus(), other.executionStatus()) && this.hasExecutionResult() == other.hasExecutionResult() && Objects.equals(this.executionResult(), other.executionResult()) && this.hasExecutionDetails() == other.hasExecutionDetails() && Objects.equals(this.executionDetails(), other.executionDetails()) && Objects.equals(this.executionEntityVersion(), other.executionEntityVersion());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeExecutionResponse").add("ExecutionId", (Object)this.executionId()).add("ActionType", (Object)this.actionType()).add("TargetResource", (Object)this.targetResource()).add("TargetResourceVersion", (Object)this.targetResourceVersion()).add("ResolveTo", (Object)this.resolveTo()).add("ExecutionStartTime", (Object)this.executionStartTime()).add("ExecutionEndTime", (Object)this.executionEndTime()).add("ExecutionStatus", (Object)this.executionStatus()).add("ExecutionResult", this.hasExecutionResult() ? this.executionResult() : null).add("ExecutionDetails", this.hasExecutionDetails() ? this.executionDetails() : null).add("ExecutionEntityVersion", (Object)this.executionEntityVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "actionType": {
                return Optional.ofNullable(clazz.cast(this.actionType()));
            }
            case "targetResource": {
                return Optional.ofNullable(clazz.cast(this.targetResource()));
            }
            case "targetResourceVersion": {
                return Optional.ofNullable(clazz.cast(this.targetResourceVersion()));
            }
            case "resolveTo": {
                return Optional.ofNullable(clazz.cast(this.resolveTo()));
            }
            case "executionStartTime": {
                return Optional.ofNullable(clazz.cast(this.executionStartTime()));
            }
            case "executionEndTime": {
                return Optional.ofNullable(clazz.cast(this.executionEndTime()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatus()));
            }
            case "executionResult": {
                return Optional.ofNullable(clazz.cast(this.executionResult()));
            }
            case "executionDetails": {
                return Optional.ofNullable(clazz.cast(this.executionDetails()));
            }
            case "executionEntityVersion": {
                return Optional.ofNullable(clazz.cast(this.executionEntityVersion()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("actionType", ACTION_TYPE_FIELD);
        map.put("targetResource", TARGET_RESOURCE_FIELD);
        map.put("targetResourceVersion", TARGET_RESOURCE_VERSION_FIELD);
        map.put("resolveTo", RESOLVE_TO_FIELD);
        map.put("executionStartTime", EXECUTION_START_TIME_FIELD);
        map.put("executionEndTime", EXECUTION_END_TIME_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("executionResult", EXECUTION_RESULT_FIELD);
        map.put("executionDetails", EXECUTION_DETAILS_FIELD);
        map.put("executionEntityVersion", EXECUTION_ENTITY_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeExecutionResponse, T> g) {
        return obj -> g.apply((DescribeExecutionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String executionId;
        private String actionType;
        private TargetResource targetResource;
        private String targetResourceVersion;
        private ResolveTo resolveTo;
        private Instant executionStartTime;
        private Instant executionEndTime;
        private ExecutionStatus executionStatus;
        private Map<String, String> executionResult = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> executionDetails = DefaultSdkAutoConstructMap.getInstance();
        private String executionEntityVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeExecutionResponse model) {
            super(model);
            this.executionId(model.executionId);
            this.actionType(model.actionType);
            this.targetResource(model.targetResource);
            this.targetResourceVersion(model.targetResourceVersion);
            this.resolveTo(model.resolveTo);
            this.executionStartTime(model.executionStartTime);
            this.executionEndTime(model.executionEndTime);
            this.executionStatus(model.executionStatus);
            this.executionResult(model.executionResult);
            this.executionDetails(model.executionDetails);
            this.executionEntityVersion(model.executionEntityVersion);
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getActionType() {
            return this.actionType;
        }

        public final void setActionType(String actionType) {
            this.actionType = actionType;
        }

        @Override
        public final Builder actionType(String actionType) {
            this.actionType = actionType;
            return this;
        }

        public final TargetResource.Builder getTargetResource() {
            return this.targetResource != null ? this.targetResource.toBuilder() : null;
        }

        public final void setTargetResource(TargetResource.BuilderImpl targetResource) {
            this.targetResource = targetResource != null ? targetResource.build() : null;
        }

        @Override
        public final Builder targetResource(TargetResource targetResource) {
            this.targetResource = targetResource;
            return this;
        }

        public final String getTargetResourceVersion() {
            return this.targetResourceVersion;
        }

        public final void setTargetResourceVersion(String targetResourceVersion) {
            this.targetResourceVersion = targetResourceVersion;
        }

        @Override
        public final Builder targetResourceVersion(String targetResourceVersion) {
            this.targetResourceVersion = targetResourceVersion;
            return this;
        }

        public final ResolveTo.Builder getResolveTo() {
            return this.resolveTo != null ? this.resolveTo.toBuilder() : null;
        }

        public final void setResolveTo(ResolveTo.BuilderImpl resolveTo) {
            this.resolveTo = resolveTo != null ? resolveTo.build() : null;
        }

        @Override
        public final Builder resolveTo(ResolveTo resolveTo) {
            this.resolveTo = resolveTo;
            return this;
        }

        public final Instant getExecutionStartTime() {
            return this.executionStartTime;
        }

        public final void setExecutionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
        }

        @Override
        public final Builder executionStartTime(Instant executionStartTime) {
            this.executionStartTime = executionStartTime;
            return this;
        }

        public final Instant getExecutionEndTime() {
            return this.executionEndTime;
        }

        public final void setExecutionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
        }

        @Override
        public final Builder executionEndTime(Instant executionEndTime) {
            this.executionEndTime = executionEndTime;
            return this;
        }

        public final ExecutionStatus.Builder getExecutionStatus() {
            return this.executionStatus != null ? this.executionStatus.toBuilder() : null;
        }

        public final void setExecutionStatus(ExecutionStatus.BuilderImpl executionStatus) {
            this.executionStatus = executionStatus != null ? executionStatus.build() : null;
        }

        @Override
        public final Builder executionStatus(ExecutionStatus executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        public final Map<String, String> getExecutionResult() {
            if (this.executionResult instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.executionResult;
        }

        public final void setExecutionResult(Map<String, String> executionResult) {
            this.executionResult = ExecutionResultCopier.copy(executionResult);
        }

        @Override
        public final Builder executionResult(Map<String, String> executionResult) {
            this.executionResult = ExecutionResultCopier.copy(executionResult);
            return this;
        }

        public final Map<String, String> getExecutionDetails() {
            if (this.executionDetails instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.executionDetails;
        }

        public final void setExecutionDetails(Map<String, String> executionDetails) {
            this.executionDetails = ExecutionDetailsCopier.copy(executionDetails);
        }

        @Override
        public final Builder executionDetails(Map<String, String> executionDetails) {
            this.executionDetails = ExecutionDetailsCopier.copy(executionDetails);
            return this;
        }

        public final String getExecutionEntityVersion() {
            return this.executionEntityVersion;
        }

        public final void setExecutionEntityVersion(String executionEntityVersion) {
            this.executionEntityVersion = executionEntityVersion;
        }

        @Override
        public final Builder executionEntityVersion(String executionEntityVersion) {
            this.executionEntityVersion = executionEntityVersion;
            return this;
        }

        @Override
        public DescribeExecutionResponse build() {
            return new DescribeExecutionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeExecutionResponse> {
        public Builder executionId(String var1);

        public Builder actionType(String var1);

        public Builder targetResource(TargetResource var1);

        default public Builder targetResource(Consumer<TargetResource.Builder> targetResource) {
            return this.targetResource((TargetResource)((TargetResource.Builder)TargetResource.builder().applyMutation(targetResource)).build());
        }

        public Builder targetResourceVersion(String var1);

        public Builder resolveTo(ResolveTo var1);

        default public Builder resolveTo(Consumer<ResolveTo.Builder> resolveTo) {
            return this.resolveTo((ResolveTo)((ResolveTo.Builder)ResolveTo.builder().applyMutation(resolveTo)).build());
        }

        public Builder executionStartTime(Instant var1);

        public Builder executionEndTime(Instant var1);

        public Builder executionStatus(ExecutionStatus var1);

        default public Builder executionStatus(Consumer<ExecutionStatus.Builder> executionStatus) {
            return this.executionStatus((ExecutionStatus)((ExecutionStatus.Builder)ExecutionStatus.builder().applyMutation(executionStatus)).build());
        }

        public Builder executionResult(Map<String, String> var1);

        public Builder executionDetails(Map<String, String> var1);

        public Builder executionEntityVersion(String var1);
    }
}

