/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetModelResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribeAssetResponse;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalRequest;
import software.amazon.awssdk.services.iotsitewise.model.DescribePortalResponse;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseRequest;
import software.amazon.awssdk.services.iotsitewise.waiters.IoTSiteWiseAsyncWaiter;
import software.amazon.awssdk.services.iotsitewise.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultIoTSiteWiseAsyncWaiter
implements IoTSiteWiseAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final IoTSiteWiseAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<DescribeAssetModelResponse> assetModelNotExistsWaiter;
    private final AsyncWaiter<DescribeAssetModelResponse> assetModelActiveWaiter;
    private final AsyncWaiter<DescribeAssetResponse> assetNotExistsWaiter;
    private final AsyncWaiter<DescribeAssetResponse> assetActiveWaiter;
    private final AsyncWaiter<DescribePortalResponse> portalNotExistsWaiter;
    private final AsyncWaiter<DescribePortalResponse> portalActiveWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultIoTSiteWiseAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (IoTSiteWiseAsyncClient)IoTSiteWiseAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.assetModelNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAssetModelResponse.class).acceptors(DefaultIoTSiteWiseAsyncWaiter.assetModelNotExistsWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseAsyncWaiter.assetModelNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.assetModelActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAssetModelResponse.class).acceptors(DefaultIoTSiteWiseAsyncWaiter.assetModelActiveWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseAsyncWaiter.assetModelActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.assetNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAssetResponse.class).acceptors(DefaultIoTSiteWiseAsyncWaiter.assetNotExistsWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseAsyncWaiter.assetNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.assetActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribeAssetResponse.class).acceptors(DefaultIoTSiteWiseAsyncWaiter.assetActiveWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseAsyncWaiter.assetActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.portalNotExistsWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribePortalResponse.class).acceptors(DefaultIoTSiteWiseAsyncWaiter.portalNotExistsWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseAsyncWaiter.portalNotExistsWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.portalActiveWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(DescribePortalResponse.class).acceptors(DefaultIoTSiteWiseAsyncWaiter.portalActiveWaiterAcceptors())).overrideConfiguration(DefaultIoTSiteWiseAsyncWaiter.portalActiveWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetResponse>> waitUntilAssetActive(DescribeAssetRequest describeAssetRequest) {
        return this.assetActiveWaiter.runAsync(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetResponse>> waitUntilAssetActive(DescribeAssetRequest describeAssetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetActiveWaiter.runAsync(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)), DefaultIoTSiteWiseAsyncWaiter.assetActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetModelResponse>> waitUntilAssetModelActive(DescribeAssetModelRequest describeAssetModelRequest) {
        return this.assetModelActiveWaiter.runAsync(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetModelResponse>> waitUntilAssetModelActive(DescribeAssetModelRequest describeAssetModelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetModelActiveWaiter.runAsync(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)), DefaultIoTSiteWiseAsyncWaiter.assetModelActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetModelResponse>> waitUntilAssetModelNotExists(DescribeAssetModelRequest describeAssetModelRequest) {
        return this.assetModelNotExistsWaiter.runAsync(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetModelResponse>> waitUntilAssetModelNotExists(DescribeAssetModelRequest describeAssetModelRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetModelNotExistsWaiter.runAsync(() -> this.client.describeAssetModel(this.applyWaitersUserAgent(describeAssetModelRequest)), DefaultIoTSiteWiseAsyncWaiter.assetModelNotExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetResponse>> waitUntilAssetNotExists(DescribeAssetRequest describeAssetRequest) {
        return this.assetNotExistsWaiter.runAsync(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribeAssetResponse>> waitUntilAssetNotExists(DescribeAssetRequest describeAssetRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.assetNotExistsWaiter.runAsync(() -> this.client.describeAsset(this.applyWaitersUserAgent(describeAssetRequest)), DefaultIoTSiteWiseAsyncWaiter.assetNotExistsWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribePortalResponse>> waitUntilPortalActive(DescribePortalRequest describePortalRequest) {
        return this.portalActiveWaiter.runAsync(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribePortalResponse>> waitUntilPortalActive(DescribePortalRequest describePortalRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.portalActiveWaiter.runAsync(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)), DefaultIoTSiteWiseAsyncWaiter.portalActiveWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribePortalResponse>> waitUntilPortalNotExists(DescribePortalRequest describePortalRequest) {
        return this.portalNotExistsWaiter.runAsync(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<DescribePortalResponse>> waitUntilPortalNotExists(DescribePortalRequest describePortalRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.portalNotExistsWaiter.runAsync(() -> this.client.describePortal(this.applyWaitersUserAgent(describePortalRequest)), DefaultIoTSiteWiseAsyncWaiter.portalNotExistsWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeAssetModelResponse>> assetModelNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultIoTSiteWiseAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAssetModelResponse>> assetModelActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetModelResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetModelStatus").field("state").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetModelStatus").field("state").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (assetModelStatus.state=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAssetResponse>> assetNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultIoTSiteWiseAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeAssetResponse>> assetActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeAssetResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeAssetResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetStatus").field("state").value(), "ACTIVE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("assetStatus").field("state").value(), "FAILED");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (assetStatus.state=FAILED) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribePortalResponse>> portalNotExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribePortalResponse>> result = new ArrayList<WaiterAcceptor<? super DescribePortalResponse>>();
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultIoTSiteWiseAsyncWaiter.errorCode(error), "ResourceNotFoundException")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribePortalResponse>> portalActiveWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribePortalResponse>> result = new ArrayList<WaiterAcceptor<? super DescribePortalResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("portalStatus").field("state").value(), "ACTIVE");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration assetModelNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration assetModelActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration assetNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration assetActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration portalNotExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration portalActiveWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(3L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static IoTSiteWiseAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends IoTSiteWiseRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((IoTSiteWiseRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements IoTSiteWiseAsyncWaiter.Builder {
        private IoTSiteWiseAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public IoTSiteWiseAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public IoTSiteWiseAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public IoTSiteWiseAsyncWaiter.Builder client(IoTSiteWiseAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public IoTSiteWiseAsyncWaiter build() {
            return new DefaultIoTSiteWiseAsyncWaiter(this);
        }
    }
}

