/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelResolveToResourceSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelResolveToResourcesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelResolveToResourcesResponse;

public class ListComputationModelResolveToResourcesIterable
implements SdkIterable<ListComputationModelResolveToResourcesResponse> {
    private final IoTSiteWiseClient client;
    private final ListComputationModelResolveToResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComputationModelResolveToResourcesIterable(IoTSiteWiseClient client, ListComputationModelResolveToResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComputationModelResolveToResourcesResponseFetcher();
    }

    public Iterator<ListComputationModelResolveToResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComputationModelResolveToResourceSummary> computationModelResolveToResourceSummaries() {
        Function<ListComputationModelResolveToResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.computationModelResolveToResourceSummaries() != null) {
                return response.computationModelResolveToResourceSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComputationModelResolveToResourcesResponseFetcher
    implements SyncPageFetcher<ListComputationModelResolveToResourcesResponse> {
        private ListComputationModelResolveToResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListComputationModelResolveToResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComputationModelResolveToResourcesResponse nextPage(ListComputationModelResolveToResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListComputationModelResolveToResourcesIterable.this.client.listComputationModelResolveToResources(ListComputationModelResolveToResourcesIterable.this.firstRequest);
            }
            return ListComputationModelResolveToResourcesIterable.this.client.listComputationModelResolveToResources((ListComputationModelResolveToResourcesRequest)((Object)ListComputationModelResolveToResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

