/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.ComputationModelDataBindingUsageSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelDataBindingUsagesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListComputationModelDataBindingUsagesResponse;

public class ListComputationModelDataBindingUsagesIterable
implements SdkIterable<ListComputationModelDataBindingUsagesResponse> {
    private final IoTSiteWiseClient client;
    private final ListComputationModelDataBindingUsagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListComputationModelDataBindingUsagesIterable(IoTSiteWiseClient client, ListComputationModelDataBindingUsagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListComputationModelDataBindingUsagesResponseFetcher();
    }

    public Iterator<ListComputationModelDataBindingUsagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ComputationModelDataBindingUsageSummary> dataBindingUsageSummaries() {
        Function<ListComputationModelDataBindingUsagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.dataBindingUsageSummaries() != null) {
                return response.dataBindingUsageSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListComputationModelDataBindingUsagesResponseFetcher
    implements SyncPageFetcher<ListComputationModelDataBindingUsagesResponse> {
        private ListComputationModelDataBindingUsagesResponseFetcher() {
        }

        public boolean hasNextPage(ListComputationModelDataBindingUsagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListComputationModelDataBindingUsagesResponse nextPage(ListComputationModelDataBindingUsagesResponse previousPage) {
            if (previousPage == null) {
                return ListComputationModelDataBindingUsagesIterable.this.client.listComputationModelDataBindingUsages(ListComputationModelDataBindingUsagesIterable.this.firstRequest);
            }
            return ListComputationModelDataBindingUsagesIterable.this.client.listComputationModelDataBindingUsages((ListComputationModelDataBindingUsagesRequest)((Object)ListComputationModelDataBindingUsagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

