/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.CompositionRelationshipSummary;
import software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListCompositionRelationshipsResponse;

public class ListCompositionRelationshipsPublisher
implements SdkPublisher<ListCompositionRelationshipsResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListCompositionRelationshipsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCompositionRelationshipsPublisher(IoTSiteWiseAsyncClient client, ListCompositionRelationshipsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCompositionRelationshipsPublisher(IoTSiteWiseAsyncClient client, ListCompositionRelationshipsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCompositionRelationshipsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCompositionRelationshipsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CompositionRelationshipSummary> compositionRelationshipSummaries() {
        Function<ListCompositionRelationshipsResponse, Iterator> getIterator = response -> {
            if (response != null && response.compositionRelationshipSummaries() != null) {
                return response.compositionRelationshipSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListCompositionRelationshipsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListCompositionRelationshipsResponseFetcher
    implements AsyncPageFetcher<ListCompositionRelationshipsResponse> {
        private ListCompositionRelationshipsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompositionRelationshipsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCompositionRelationshipsResponse> nextPage(ListCompositionRelationshipsResponse previousPage) {
            if (previousPage == null) {
                return ListCompositionRelationshipsPublisher.this.client.listCompositionRelationships(ListCompositionRelationshipsPublisher.this.firstRequest);
            }
            return ListCompositionRelationshipsPublisher.this.client.listCompositionRelationships((ListCompositionRelationshipsRequest)((Object)ListCompositionRelationshipsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

