/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AccessPolicySummary;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.iotsitewise.model.ListAccessPoliciesResponse;

public class ListAccessPoliciesPublisher
implements SdkPublisher<ListAccessPoliciesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final ListAccessPoliciesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccessPoliciesPublisher(IoTSiteWiseAsyncClient client, ListAccessPoliciesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccessPoliciesPublisher(IoTSiteWiseAsyncClient client, ListAccessPoliciesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccessPoliciesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccessPoliciesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccessPolicySummary> accessPolicySummaries() {
        Function<ListAccessPoliciesResponse, Iterator> getIterator = response -> {
            if (response != null && response.accessPolicySummaries() != null) {
                return response.accessPolicySummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccessPoliciesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccessPoliciesResponseFetcher
    implements AsyncPageFetcher<ListAccessPoliciesResponse> {
        private ListAccessPoliciesResponseFetcher() {
        }

        public boolean hasNextPage(ListAccessPoliciesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccessPoliciesResponse> nextPage(ListAccessPoliciesResponse previousPage) {
            if (previousPage == null) {
                return ListAccessPoliciesPublisher.this.client.listAccessPolicies(ListAccessPoliciesPublisher.this.firstRequest);
            }
            return ListAccessPoliciesPublisher.this.client.listAccessPolicies((ListAccessPoliciesRequest)((Object)ListAccessPoliciesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

