/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesErrorEntry;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSkippedEntry;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntriesCopier;
import software.amazon.awssdk.services.iotsitewise.model.BatchGetAssetPropertyAggregatesSuccessEntry;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetAssetPropertyAggregatesResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, BatchGetAssetPropertyAggregatesResponse> {
    private static final SdkField<List<BatchGetAssetPropertyAggregatesErrorEntry>> ERROR_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errorEntries").getter(BatchGetAssetPropertyAggregatesResponse.getter(BatchGetAssetPropertyAggregatesResponse::errorEntries)).setter(BatchGetAssetPropertyAggregatesResponse.setter(Builder::errorEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyAggregatesErrorEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetAssetPropertyAggregatesSuccessEntry>> SUCCESS_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("successEntries").getter(BatchGetAssetPropertyAggregatesResponse.getter(BatchGetAssetPropertyAggregatesResponse::successEntries)).setter(BatchGetAssetPropertyAggregatesResponse.setter(Builder::successEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("successEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyAggregatesSuccessEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetAssetPropertyAggregatesSkippedEntry>> SKIPPED_ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("skippedEntries").getter(BatchGetAssetPropertyAggregatesResponse.getter(BatchGetAssetPropertyAggregatesResponse::skippedEntries)).setter(BatchGetAssetPropertyAggregatesResponse.setter(Builder::skippedEntries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("skippedEntries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetAssetPropertyAggregatesSkippedEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(BatchGetAssetPropertyAggregatesResponse.getter(BatchGetAssetPropertyAggregatesResponse::nextToken)).setter(BatchGetAssetPropertyAggregatesResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_ENTRIES_FIELD, SUCCESS_ENTRIES_FIELD, SKIPPED_ENTRIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetAssetPropertyAggregatesResponse.memberNameToFieldInitializer();
    private final List<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries;
    private final List<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries;
    private final List<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries;
    private final String nextToken;

    private BatchGetAssetPropertyAggregatesResponse(BuilderImpl builder) {
        super(builder);
        this.errorEntries = builder.errorEntries;
        this.successEntries = builder.successEntries;
        this.skippedEntries = builder.skippedEntries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasErrorEntries() {
        return this.errorEntries != null && !(this.errorEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries() {
        return this.errorEntries;
    }

    public final boolean hasSuccessEntries() {
        return this.successEntries != null && !(this.successEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries() {
        return this.successEntries;
    }

    public final boolean hasSkippedEntries() {
        return this.skippedEntries != null && !(this.skippedEntries instanceof SdkAutoConstructList);
    }

    public final List<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries() {
        return this.skippedEntries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrorEntries() ? this.errorEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSuccessEntries() ? this.successEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkippedEntries() ? this.skippedEntries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetAssetPropertyAggregatesResponse)) {
            return false;
        }
        BatchGetAssetPropertyAggregatesResponse other = (BatchGetAssetPropertyAggregatesResponse)((Object)obj);
        return this.hasErrorEntries() == other.hasErrorEntries() && Objects.equals(this.errorEntries(), other.errorEntries()) && this.hasSuccessEntries() == other.hasSuccessEntries() && Objects.equals(this.successEntries(), other.successEntries()) && this.hasSkippedEntries() == other.hasSkippedEntries() && Objects.equals(this.skippedEntries(), other.skippedEntries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetAssetPropertyAggregatesResponse").add("ErrorEntries", this.hasErrorEntries() ? this.errorEntries() : null).add("SuccessEntries", this.hasSuccessEntries() ? this.successEntries() : null).add("SkippedEntries", this.hasSkippedEntries() ? this.skippedEntries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorEntries": {
                return Optional.ofNullable(clazz.cast(this.errorEntries()));
            }
            case "successEntries": {
                return Optional.ofNullable(clazz.cast(this.successEntries()));
            }
            case "skippedEntries": {
                return Optional.ofNullable(clazz.cast(this.skippedEntries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("errorEntries", ERROR_ENTRIES_FIELD);
        map.put("successEntries", SUCCESS_ENTRIES_FIELD);
        map.put("skippedEntries", SKIPPED_ENTRIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetAssetPropertyAggregatesResponse, T> g) {
        return obj -> g.apply((BatchGetAssetPropertyAggregatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private List<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetAssetPropertyAggregatesResponse model) {
            super(model);
            this.errorEntries(model.errorEntries);
            this.successEntries(model.successEntries);
            this.skippedEntries(model.skippedEntries);
            this.nextToken(model.nextToken);
        }

        public final List<BatchGetAssetPropertyAggregatesErrorEntry.Builder> getErrorEntries() {
            List<BatchGetAssetPropertyAggregatesErrorEntry.Builder> result = BatchGetAssetPropertyAggregatesErrorEntriesCopier.copyToBuilder(this.errorEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorEntries(Collection<BatchGetAssetPropertyAggregatesErrorEntry.BuilderImpl> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyAggregatesErrorEntriesCopier.copyFromBuilder(errorEntries);
        }

        @Override
        public final Builder errorEntries(Collection<BatchGetAssetPropertyAggregatesErrorEntry> errorEntries) {
            this.errorEntries = BatchGetAssetPropertyAggregatesErrorEntriesCopier.copy(errorEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(BatchGetAssetPropertyAggregatesErrorEntry ... errorEntries) {
            this.errorEntries(Arrays.asList(errorEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorEntries(Consumer<BatchGetAssetPropertyAggregatesErrorEntry.Builder> ... errorEntries) {
            this.errorEntries(Stream.of(errorEntries).map(c -> (BatchGetAssetPropertyAggregatesErrorEntry)((BatchGetAssetPropertyAggregatesErrorEntry.Builder)BatchGetAssetPropertyAggregatesErrorEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyAggregatesSuccessEntry.Builder> getSuccessEntries() {
            List<BatchGetAssetPropertyAggregatesSuccessEntry.Builder> result = BatchGetAssetPropertyAggregatesSuccessEntriesCopier.copyToBuilder(this.successEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSuccessEntries(Collection<BatchGetAssetPropertyAggregatesSuccessEntry.BuilderImpl> successEntries) {
            this.successEntries = BatchGetAssetPropertyAggregatesSuccessEntriesCopier.copyFromBuilder(successEntries);
        }

        @Override
        public final Builder successEntries(Collection<BatchGetAssetPropertyAggregatesSuccessEntry> successEntries) {
            this.successEntries = BatchGetAssetPropertyAggregatesSuccessEntriesCopier.copy(successEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(BatchGetAssetPropertyAggregatesSuccessEntry ... successEntries) {
            this.successEntries(Arrays.asList(successEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder successEntries(Consumer<BatchGetAssetPropertyAggregatesSuccessEntry.Builder> ... successEntries) {
            this.successEntries(Stream.of(successEntries).map(c -> (BatchGetAssetPropertyAggregatesSuccessEntry)((BatchGetAssetPropertyAggregatesSuccessEntry.Builder)BatchGetAssetPropertyAggregatesSuccessEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> getSkippedEntries() {
            List<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> result = BatchGetAssetPropertyAggregatesSkippedEntriesCopier.copyToBuilder(this.skippedEntries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSkippedEntries(Collection<BatchGetAssetPropertyAggregatesSkippedEntry.BuilderImpl> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyAggregatesSkippedEntriesCopier.copyFromBuilder(skippedEntries);
        }

        @Override
        public final Builder skippedEntries(Collection<BatchGetAssetPropertyAggregatesSkippedEntry> skippedEntries) {
            this.skippedEntries = BatchGetAssetPropertyAggregatesSkippedEntriesCopier.copy(skippedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(BatchGetAssetPropertyAggregatesSkippedEntry ... skippedEntries) {
            this.skippedEntries(Arrays.asList(skippedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skippedEntries(Consumer<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> ... skippedEntries) {
            this.skippedEntries(Stream.of(skippedEntries).map(c -> (BatchGetAssetPropertyAggregatesSkippedEntry)((BatchGetAssetPropertyAggregatesSkippedEntry.Builder)BatchGetAssetPropertyAggregatesSkippedEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public BatchGetAssetPropertyAggregatesResponse build() {
            return new BatchGetAssetPropertyAggregatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetAssetPropertyAggregatesResponse> {
        public Builder errorEntries(Collection<BatchGetAssetPropertyAggregatesErrorEntry> var1);

        public Builder errorEntries(BatchGetAssetPropertyAggregatesErrorEntry ... var1);

        public Builder errorEntries(Consumer<BatchGetAssetPropertyAggregatesErrorEntry.Builder> ... var1);

        public Builder successEntries(Collection<BatchGetAssetPropertyAggregatesSuccessEntry> var1);

        public Builder successEntries(BatchGetAssetPropertyAggregatesSuccessEntry ... var1);

        public Builder successEntries(Consumer<BatchGetAssetPropertyAggregatesSuccessEntry.Builder> ... var1);

        public Builder skippedEntries(Collection<BatchGetAssetPropertyAggregatesSkippedEntry> var1);

        public Builder skippedEntries(BatchGetAssetPropertyAggregatesSkippedEntry ... var1);

        public Builder skippedEntries(Consumer<BatchGetAssetPropertyAggregatesSkippedEntry.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

