/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotsitewise.IoTSiteWiseAsyncClient;
import software.amazon.awssdk.services.iotsitewise.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotsitewise.model.AggregatedValue;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesRequest;
import software.amazon.awssdk.services.iotsitewise.model.GetAssetPropertyAggregatesResponse;

public class GetAssetPropertyAggregatesPublisher
implements SdkPublisher<GetAssetPropertyAggregatesResponse> {
    private final IoTSiteWiseAsyncClient client;
    private final GetAssetPropertyAggregatesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetAssetPropertyAggregatesPublisher(IoTSiteWiseAsyncClient client, GetAssetPropertyAggregatesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetAssetPropertyAggregatesPublisher(IoTSiteWiseAsyncClient client, GetAssetPropertyAggregatesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetAssetPropertyAggregatesResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetAssetPropertyAggregatesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AggregatedValue> aggregatedValues() {
        Function<GetAssetPropertyAggregatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.aggregatedValues() != null) {
                return response.aggregatedValues().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new GetAssetPropertyAggregatesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class GetAssetPropertyAggregatesResponseFetcher
    implements AsyncPageFetcher<GetAssetPropertyAggregatesResponse> {
        private GetAssetPropertyAggregatesResponseFetcher() {
        }

        public boolean hasNextPage(GetAssetPropertyAggregatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetAssetPropertyAggregatesResponse> nextPage(GetAssetPropertyAggregatesResponse previousPage) {
            if (previousPage == null) {
                return GetAssetPropertyAggregatesPublisher.this.client.getAssetPropertyAggregates(GetAssetPropertyAggregatesPublisher.this.firstRequest);
            }
            return GetAssetPropertyAggregatesPublisher.this.client.getAssetPropertyAggregates((GetAssetPropertyAggregatesRequest)((Object)GetAssetPropertyAggregatesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

