/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotsitewise.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.iotsitewise.model.ActionDefinition;
import software.amazon.awssdk.services.iotsitewise.model.ActionDefinitionsCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelPathSegment;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummariesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetCompositeModelSummary;
import software.amazon.awssdk.services.iotsitewise.model.AssetPropertiesCopier;
import software.amazon.awssdk.services.iotsitewise.model.AssetProperty;
import software.amazon.awssdk.services.iotsitewise.model.IoTSiteWiseResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAssetCompositeModelResponse
extends IoTSiteWiseResponse
implements ToCopyableBuilder<Builder, DescribeAssetCompositeModelResponse> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetId)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_COMPOSITE_MODEL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetCompositeModelId").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelId)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelId").build()}).build();
    private static final SdkField<String> ASSET_COMPOSITE_MODEL_EXTERNAL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetCompositeModelExternalId").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelExternalId)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelExternalId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelExternalId").build()}).build();
    private static final SdkField<List<AssetCompositeModelPathSegment>> ASSET_COMPOSITE_MODEL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetCompositeModelPath").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelPath)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelPath").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetCompositeModelPathSegment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ASSET_COMPOSITE_MODEL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetCompositeModelName").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelName)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelName").build()}).build();
    private static final SdkField<String> ASSET_COMPOSITE_MODEL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetCompositeModelDescription").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelDescription)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelDescription").build()}).build();
    private static final SdkField<String> ASSET_COMPOSITE_MODEL_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetCompositeModelType").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelType)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelType").build()}).build();
    private static final SdkField<List<AssetProperty>> ASSET_COMPOSITE_MODEL_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetCompositeModelProperties").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelProperties)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelProperties").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AssetCompositeModelSummary>> ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetCompositeModelSummaries").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::assetCompositeModelSummaries)).setter(DescribeAssetCompositeModelResponse.setter(Builder::assetCompositeModelSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetCompositeModelSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AssetCompositeModelSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ActionDefinition>> ACTION_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("actionDefinitions").getter(DescribeAssetCompositeModelResponse.getter(DescribeAssetCompositeModelResponse::actionDefinitions)).setter(DescribeAssetCompositeModelResponse.setter(Builder::actionDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ActionDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_COMPOSITE_MODEL_ID_FIELD, ASSET_COMPOSITE_MODEL_EXTERNAL_ID_FIELD, ASSET_COMPOSITE_MODEL_PATH_FIELD, ASSET_COMPOSITE_MODEL_NAME_FIELD, ASSET_COMPOSITE_MODEL_DESCRIPTION_FIELD, ASSET_COMPOSITE_MODEL_TYPE_FIELD, ASSET_COMPOSITE_MODEL_PROPERTIES_FIELD, ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD, ACTION_DEFINITIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeAssetCompositeModelResponse.memberNameToFieldInitializer();
    private final String assetId;
    private final String assetCompositeModelId;
    private final String assetCompositeModelExternalId;
    private final List<AssetCompositeModelPathSegment> assetCompositeModelPath;
    private final String assetCompositeModelName;
    private final String assetCompositeModelDescription;
    private final String assetCompositeModelType;
    private final List<AssetProperty> assetCompositeModelProperties;
    private final List<AssetCompositeModelSummary> assetCompositeModelSummaries;
    private final List<ActionDefinition> actionDefinitions;

    private DescribeAssetCompositeModelResponse(BuilderImpl builder) {
        super(builder);
        this.assetId = builder.assetId;
        this.assetCompositeModelId = builder.assetCompositeModelId;
        this.assetCompositeModelExternalId = builder.assetCompositeModelExternalId;
        this.assetCompositeModelPath = builder.assetCompositeModelPath;
        this.assetCompositeModelName = builder.assetCompositeModelName;
        this.assetCompositeModelDescription = builder.assetCompositeModelDescription;
        this.assetCompositeModelType = builder.assetCompositeModelType;
        this.assetCompositeModelProperties = builder.assetCompositeModelProperties;
        this.assetCompositeModelSummaries = builder.assetCompositeModelSummaries;
        this.actionDefinitions = builder.actionDefinitions;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetCompositeModelId() {
        return this.assetCompositeModelId;
    }

    public final String assetCompositeModelExternalId() {
        return this.assetCompositeModelExternalId;
    }

    public final boolean hasAssetCompositeModelPath() {
        return this.assetCompositeModelPath != null && !(this.assetCompositeModelPath instanceof SdkAutoConstructList);
    }

    public final List<AssetCompositeModelPathSegment> assetCompositeModelPath() {
        return this.assetCompositeModelPath;
    }

    public final String assetCompositeModelName() {
        return this.assetCompositeModelName;
    }

    public final String assetCompositeModelDescription() {
        return this.assetCompositeModelDescription;
    }

    public final String assetCompositeModelType() {
        return this.assetCompositeModelType;
    }

    public final boolean hasAssetCompositeModelProperties() {
        return this.assetCompositeModelProperties != null && !(this.assetCompositeModelProperties instanceof SdkAutoConstructList);
    }

    public final List<AssetProperty> assetCompositeModelProperties() {
        return this.assetCompositeModelProperties;
    }

    public final boolean hasAssetCompositeModelSummaries() {
        return this.assetCompositeModelSummaries != null && !(this.assetCompositeModelSummaries instanceof SdkAutoConstructList);
    }

    public final List<AssetCompositeModelSummary> assetCompositeModelSummaries() {
        return this.assetCompositeModelSummaries;
    }

    public final boolean hasActionDefinitions() {
        return this.actionDefinitions != null && !(this.actionDefinitions instanceof SdkAutoConstructList);
    }

    public final List<ActionDefinition> actionDefinitions() {
        return this.actionDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCompositeModelId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCompositeModelExternalId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetCompositeModelPath() ? this.assetCompositeModelPath() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCompositeModelName());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCompositeModelDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetCompositeModelType());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetCompositeModelProperties() ? this.assetCompositeModelProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetCompositeModelSummaries() ? this.assetCompositeModelSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasActionDefinitions() ? this.actionDefinitions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAssetCompositeModelResponse)) {
            return false;
        }
        DescribeAssetCompositeModelResponse other = (DescribeAssetCompositeModelResponse)((Object)obj);
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetCompositeModelId(), other.assetCompositeModelId()) && Objects.equals(this.assetCompositeModelExternalId(), other.assetCompositeModelExternalId()) && this.hasAssetCompositeModelPath() == other.hasAssetCompositeModelPath() && Objects.equals(this.assetCompositeModelPath(), other.assetCompositeModelPath()) && Objects.equals(this.assetCompositeModelName(), other.assetCompositeModelName()) && Objects.equals(this.assetCompositeModelDescription(), other.assetCompositeModelDescription()) && Objects.equals(this.assetCompositeModelType(), other.assetCompositeModelType()) && this.hasAssetCompositeModelProperties() == other.hasAssetCompositeModelProperties() && Objects.equals(this.assetCompositeModelProperties(), other.assetCompositeModelProperties()) && this.hasAssetCompositeModelSummaries() == other.hasAssetCompositeModelSummaries() && Objects.equals(this.assetCompositeModelSummaries(), other.assetCompositeModelSummaries()) && this.hasActionDefinitions() == other.hasActionDefinitions() && Objects.equals(this.actionDefinitions(), other.actionDefinitions());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAssetCompositeModelResponse").add("AssetId", (Object)this.assetId()).add("AssetCompositeModelId", (Object)this.assetCompositeModelId()).add("AssetCompositeModelExternalId", (Object)this.assetCompositeModelExternalId()).add("AssetCompositeModelPath", this.hasAssetCompositeModelPath() ? this.assetCompositeModelPath() : null).add("AssetCompositeModelName", (Object)this.assetCompositeModelName()).add("AssetCompositeModelDescription", (Object)this.assetCompositeModelDescription()).add("AssetCompositeModelType", (Object)this.assetCompositeModelType()).add("AssetCompositeModelProperties", this.hasAssetCompositeModelProperties() ? this.assetCompositeModelProperties() : null).add("AssetCompositeModelSummaries", this.hasAssetCompositeModelSummaries() ? this.assetCompositeModelSummaries() : null).add("ActionDefinitions", this.hasActionDefinitions() ? this.actionDefinitions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetCompositeModelId": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelId()));
            }
            case "assetCompositeModelExternalId": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelExternalId()));
            }
            case "assetCompositeModelPath": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelPath()));
            }
            case "assetCompositeModelName": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelName()));
            }
            case "assetCompositeModelDescription": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelDescription()));
            }
            case "assetCompositeModelType": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelType()));
            }
            case "assetCompositeModelProperties": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelProperties()));
            }
            case "assetCompositeModelSummaries": {
                return Optional.ofNullable(clazz.cast(this.assetCompositeModelSummaries()));
            }
            case "actionDefinitions": {
                return Optional.ofNullable(clazz.cast(this.actionDefinitions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetId", ASSET_ID_FIELD);
        map.put("assetCompositeModelId", ASSET_COMPOSITE_MODEL_ID_FIELD);
        map.put("assetCompositeModelExternalId", ASSET_COMPOSITE_MODEL_EXTERNAL_ID_FIELD);
        map.put("assetCompositeModelPath", ASSET_COMPOSITE_MODEL_PATH_FIELD);
        map.put("assetCompositeModelName", ASSET_COMPOSITE_MODEL_NAME_FIELD);
        map.put("assetCompositeModelDescription", ASSET_COMPOSITE_MODEL_DESCRIPTION_FIELD);
        map.put("assetCompositeModelType", ASSET_COMPOSITE_MODEL_TYPE_FIELD);
        map.put("assetCompositeModelProperties", ASSET_COMPOSITE_MODEL_PROPERTIES_FIELD);
        map.put("assetCompositeModelSummaries", ASSET_COMPOSITE_MODEL_SUMMARIES_FIELD);
        map.put("actionDefinitions", ACTION_DEFINITIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeAssetCompositeModelResponse, T> g) {
        return obj -> g.apply((DescribeAssetCompositeModelResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends IoTSiteWiseResponse.BuilderImpl
    implements Builder {
        private String assetId;
        private String assetCompositeModelId;
        private String assetCompositeModelExternalId;
        private List<AssetCompositeModelPathSegment> assetCompositeModelPath = DefaultSdkAutoConstructList.getInstance();
        private String assetCompositeModelName;
        private String assetCompositeModelDescription;
        private String assetCompositeModelType;
        private List<AssetProperty> assetCompositeModelProperties = DefaultSdkAutoConstructList.getInstance();
        private List<AssetCompositeModelSummary> assetCompositeModelSummaries = DefaultSdkAutoConstructList.getInstance();
        private List<ActionDefinition> actionDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAssetCompositeModelResponse model) {
            super(model);
            this.assetId(model.assetId);
            this.assetCompositeModelId(model.assetCompositeModelId);
            this.assetCompositeModelExternalId(model.assetCompositeModelExternalId);
            this.assetCompositeModelPath(model.assetCompositeModelPath);
            this.assetCompositeModelName(model.assetCompositeModelName);
            this.assetCompositeModelDescription(model.assetCompositeModelDescription);
            this.assetCompositeModelType(model.assetCompositeModelType);
            this.assetCompositeModelProperties(model.assetCompositeModelProperties);
            this.assetCompositeModelSummaries(model.assetCompositeModelSummaries);
            this.actionDefinitions(model.actionDefinitions);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetCompositeModelId() {
            return this.assetCompositeModelId;
        }

        public final void setAssetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
        }

        @Override
        public final Builder assetCompositeModelId(String assetCompositeModelId) {
            this.assetCompositeModelId = assetCompositeModelId;
            return this;
        }

        public final String getAssetCompositeModelExternalId() {
            return this.assetCompositeModelExternalId;
        }

        public final void setAssetCompositeModelExternalId(String assetCompositeModelExternalId) {
            this.assetCompositeModelExternalId = assetCompositeModelExternalId;
        }

        @Override
        public final Builder assetCompositeModelExternalId(String assetCompositeModelExternalId) {
            this.assetCompositeModelExternalId = assetCompositeModelExternalId;
            return this;
        }

        public final List<AssetCompositeModelPathSegment.Builder> getAssetCompositeModelPath() {
            List<AssetCompositeModelPathSegment.Builder> result = AssetCompositeModelPathCopier.copyToBuilder(this.assetCompositeModelPath);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelPath(Collection<AssetCompositeModelPathSegment.BuilderImpl> assetCompositeModelPath) {
            this.assetCompositeModelPath = AssetCompositeModelPathCopier.copyFromBuilder(assetCompositeModelPath);
        }

        @Override
        public final Builder assetCompositeModelPath(Collection<AssetCompositeModelPathSegment> assetCompositeModelPath) {
            this.assetCompositeModelPath = AssetCompositeModelPathCopier.copy(assetCompositeModelPath);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelPath(AssetCompositeModelPathSegment ... assetCompositeModelPath) {
            this.assetCompositeModelPath(Arrays.asList(assetCompositeModelPath));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelPath(Consumer<AssetCompositeModelPathSegment.Builder> ... assetCompositeModelPath) {
            this.assetCompositeModelPath(Stream.of(assetCompositeModelPath).map(c -> (AssetCompositeModelPathSegment)((AssetCompositeModelPathSegment.Builder)AssetCompositeModelPathSegment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAssetCompositeModelName() {
            return this.assetCompositeModelName;
        }

        public final void setAssetCompositeModelName(String assetCompositeModelName) {
            this.assetCompositeModelName = assetCompositeModelName;
        }

        @Override
        public final Builder assetCompositeModelName(String assetCompositeModelName) {
            this.assetCompositeModelName = assetCompositeModelName;
            return this;
        }

        public final String getAssetCompositeModelDescription() {
            return this.assetCompositeModelDescription;
        }

        public final void setAssetCompositeModelDescription(String assetCompositeModelDescription) {
            this.assetCompositeModelDescription = assetCompositeModelDescription;
        }

        @Override
        public final Builder assetCompositeModelDescription(String assetCompositeModelDescription) {
            this.assetCompositeModelDescription = assetCompositeModelDescription;
            return this;
        }

        public final String getAssetCompositeModelType() {
            return this.assetCompositeModelType;
        }

        public final void setAssetCompositeModelType(String assetCompositeModelType) {
            this.assetCompositeModelType = assetCompositeModelType;
        }

        @Override
        public final Builder assetCompositeModelType(String assetCompositeModelType) {
            this.assetCompositeModelType = assetCompositeModelType;
            return this;
        }

        public final List<AssetProperty.Builder> getAssetCompositeModelProperties() {
            List<AssetProperty.Builder> result = AssetPropertiesCopier.copyToBuilder(this.assetCompositeModelProperties);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelProperties(Collection<AssetProperty.BuilderImpl> assetCompositeModelProperties) {
            this.assetCompositeModelProperties = AssetPropertiesCopier.copyFromBuilder(assetCompositeModelProperties);
        }

        @Override
        public final Builder assetCompositeModelProperties(Collection<AssetProperty> assetCompositeModelProperties) {
            this.assetCompositeModelProperties = AssetPropertiesCopier.copy(assetCompositeModelProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelProperties(AssetProperty ... assetCompositeModelProperties) {
            this.assetCompositeModelProperties(Arrays.asList(assetCompositeModelProperties));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelProperties(Consumer<AssetProperty.Builder> ... assetCompositeModelProperties) {
            this.assetCompositeModelProperties(Stream.of(assetCompositeModelProperties).map(c -> (AssetProperty)((AssetProperty.Builder)AssetProperty.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AssetCompositeModelSummary.Builder> getAssetCompositeModelSummaries() {
            List<AssetCompositeModelSummary.Builder> result = AssetCompositeModelSummariesCopier.copyToBuilder(this.assetCompositeModelSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetCompositeModelSummaries(Collection<AssetCompositeModelSummary.BuilderImpl> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copyFromBuilder(assetCompositeModelSummaries);
        }

        @Override
        public final Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries = AssetCompositeModelSummariesCopier.copy(assetCompositeModelSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(AssetCompositeModelSummary ... assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries(Arrays.asList(assetCompositeModelSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetCompositeModelSummaries(Consumer<AssetCompositeModelSummary.Builder> ... assetCompositeModelSummaries) {
            this.assetCompositeModelSummaries(Stream.of(assetCompositeModelSummaries).map(c -> (AssetCompositeModelSummary)((AssetCompositeModelSummary.Builder)AssetCompositeModelSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ActionDefinition.Builder> getActionDefinitions() {
            List<ActionDefinition.Builder> result = ActionDefinitionsCopier.copyToBuilder(this.actionDefinitions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setActionDefinitions(Collection<ActionDefinition.BuilderImpl> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copyFromBuilder(actionDefinitions);
        }

        @Override
        public final Builder actionDefinitions(Collection<ActionDefinition> actionDefinitions) {
            this.actionDefinitions = ActionDefinitionsCopier.copy(actionDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(ActionDefinition ... actionDefinitions) {
            this.actionDefinitions(Arrays.asList(actionDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder actionDefinitions(Consumer<ActionDefinition.Builder> ... actionDefinitions) {
            this.actionDefinitions(Stream.of(actionDefinitions).map(c -> (ActionDefinition)((ActionDefinition.Builder)ActionDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeAssetCompositeModelResponse build() {
            return new DescribeAssetCompositeModelResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends IoTSiteWiseResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAssetCompositeModelResponse> {
        public Builder assetId(String var1);

        public Builder assetCompositeModelId(String var1);

        public Builder assetCompositeModelExternalId(String var1);

        public Builder assetCompositeModelPath(Collection<AssetCompositeModelPathSegment> var1);

        public Builder assetCompositeModelPath(AssetCompositeModelPathSegment ... var1);

        public Builder assetCompositeModelPath(Consumer<AssetCompositeModelPathSegment.Builder> ... var1);

        public Builder assetCompositeModelName(String var1);

        public Builder assetCompositeModelDescription(String var1);

        public Builder assetCompositeModelType(String var1);

        public Builder assetCompositeModelProperties(Collection<AssetProperty> var1);

        public Builder assetCompositeModelProperties(AssetProperty ... var1);

        public Builder assetCompositeModelProperties(Consumer<AssetProperty.Builder> ... var1);

        public Builder assetCompositeModelSummaries(Collection<AssetCompositeModelSummary> var1);

        public Builder assetCompositeModelSummaries(AssetCompositeModelSummary ... var1);

        public Builder assetCompositeModelSummaries(Consumer<AssetCompositeModelSummary.Builder> ... var1);

        public Builder actionDefinitions(Collection<ActionDefinition> var1);

        public Builder actionDefinitions(ActionDefinition ... var1);

        public Builder actionDefinitions(Consumer<ActionDefinition.Builder> ... var1);
    }
}

