/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.iotmanagedintegrations.model.LogLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuntimeLogConfigurations
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuntimeLogConfigurations> {
    private static final SdkField<String> LOG_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogLevel").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::logLevelAsString)).setter(RuntimeLogConfigurations.setter(Builder::logLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogLevel").build()}).build();
    private static final SdkField<String> LOG_FLUSH_LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogFlushLevel").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::logFlushLevelAsString)).setter(RuntimeLogConfigurations.setter(Builder::logFlushLevel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogFlushLevel").build()}).build();
    private static final SdkField<String> LOCAL_STORE_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalStoreLocation").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::localStoreLocation)).setter(RuntimeLogConfigurations.setter(Builder::localStoreLocation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStoreLocation").build()}).build();
    private static final SdkField<Integer> LOCAL_STORE_FILE_ROTATION_MAX_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LocalStoreFileRotationMaxFiles").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::localStoreFileRotationMaxFiles)).setter(RuntimeLogConfigurations.setter(Builder::localStoreFileRotationMaxFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStoreFileRotationMaxFiles").build()}).build();
    private static final SdkField<Integer> LOCAL_STORE_FILE_ROTATION_MAX_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("LocalStoreFileRotationMaxBytes").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::localStoreFileRotationMaxBytes)).setter(RuntimeLogConfigurations.setter(Builder::localStoreFileRotationMaxBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalStoreFileRotationMaxBytes").build()}).build();
    private static final SdkField<Boolean> UPLOAD_LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UploadLog").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::uploadLog)).setter(RuntimeLogConfigurations.setter(Builder::uploadLog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadLog").build()}).build();
    private static final SdkField<Integer> UPLOAD_PERIOD_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("UploadPeriodMinutes").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::uploadPeriodMinutes)).setter(RuntimeLogConfigurations.setter(Builder::uploadPeriodMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UploadPeriodMinutes").build()}).build();
    private static final SdkField<Boolean> DELETE_LOCAL_STORE_AFTER_UPLOAD_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DeleteLocalStoreAfterUpload").getter(RuntimeLogConfigurations.getter(RuntimeLogConfigurations::deleteLocalStoreAfterUpload)).setter(RuntimeLogConfigurations.setter(Builder::deleteLocalStoreAfterUpload)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeleteLocalStoreAfterUpload").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_LEVEL_FIELD, LOG_FLUSH_LEVEL_FIELD, LOCAL_STORE_LOCATION_FIELD, LOCAL_STORE_FILE_ROTATION_MAX_FILES_FIELD, LOCAL_STORE_FILE_ROTATION_MAX_BYTES_FIELD, UPLOAD_LOG_FIELD, UPLOAD_PERIOD_MINUTES_FIELD, DELETE_LOCAL_STORE_AFTER_UPLOAD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuntimeLogConfigurations.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String logLevel;
    private final String logFlushLevel;
    private final String localStoreLocation;
    private final Integer localStoreFileRotationMaxFiles;
    private final Integer localStoreFileRotationMaxBytes;
    private final Boolean uploadLog;
    private final Integer uploadPeriodMinutes;
    private final Boolean deleteLocalStoreAfterUpload;

    private RuntimeLogConfigurations(BuilderImpl builder) {
        this.logLevel = builder.logLevel;
        this.logFlushLevel = builder.logFlushLevel;
        this.localStoreLocation = builder.localStoreLocation;
        this.localStoreFileRotationMaxFiles = builder.localStoreFileRotationMaxFiles;
        this.localStoreFileRotationMaxBytes = builder.localStoreFileRotationMaxBytes;
        this.uploadLog = builder.uploadLog;
        this.uploadPeriodMinutes = builder.uploadPeriodMinutes;
        this.deleteLocalStoreAfterUpload = builder.deleteLocalStoreAfterUpload;
    }

    public final LogLevel logLevel() {
        return LogLevel.fromValue(this.logLevel);
    }

    public final String logLevelAsString() {
        return this.logLevel;
    }

    public final LogLevel logFlushLevel() {
        return LogLevel.fromValue(this.logFlushLevel);
    }

    public final String logFlushLevelAsString() {
        return this.logFlushLevel;
    }

    public final String localStoreLocation() {
        return this.localStoreLocation;
    }

    public final Integer localStoreFileRotationMaxFiles() {
        return this.localStoreFileRotationMaxFiles;
    }

    public final Integer localStoreFileRotationMaxBytes() {
        return this.localStoreFileRotationMaxBytes;
    }

    public final Boolean uploadLog() {
        return this.uploadLog;
    }

    public final Integer uploadPeriodMinutes() {
        return this.uploadPeriodMinutes;
    }

    public final Boolean deleteLocalStoreAfterUpload() {
        return this.deleteLocalStoreAfterUpload;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.logFlushLevelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.localStoreLocation());
        hashCode = 31 * hashCode + Objects.hashCode(this.localStoreFileRotationMaxFiles());
        hashCode = 31 * hashCode + Objects.hashCode(this.localStoreFileRotationMaxBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadLog());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadPeriodMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.deleteLocalStoreAfterUpload());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuntimeLogConfigurations)) {
            return false;
        }
        RuntimeLogConfigurations other = (RuntimeLogConfigurations)obj;
        return Objects.equals(this.logLevelAsString(), other.logLevelAsString()) && Objects.equals(this.logFlushLevelAsString(), other.logFlushLevelAsString()) && Objects.equals(this.localStoreLocation(), other.localStoreLocation()) && Objects.equals(this.localStoreFileRotationMaxFiles(), other.localStoreFileRotationMaxFiles()) && Objects.equals(this.localStoreFileRotationMaxBytes(), other.localStoreFileRotationMaxBytes()) && Objects.equals(this.uploadLog(), other.uploadLog()) && Objects.equals(this.uploadPeriodMinutes(), other.uploadPeriodMinutes()) && Objects.equals(this.deleteLocalStoreAfterUpload(), other.deleteLocalStoreAfterUpload());
    }

    public final String toString() {
        return ToString.builder((String)"RuntimeLogConfigurations").add("LogLevel", (Object)this.logLevelAsString()).add("LogFlushLevel", (Object)this.logFlushLevelAsString()).add("LocalStoreLocation", (Object)this.localStoreLocation()).add("LocalStoreFileRotationMaxFiles", (Object)this.localStoreFileRotationMaxFiles()).add("LocalStoreFileRotationMaxBytes", (Object)this.localStoreFileRotationMaxBytes()).add("UploadLog", (Object)this.uploadLog()).add("UploadPeriodMinutes", (Object)this.uploadPeriodMinutes()).add("DeleteLocalStoreAfterUpload", (Object)this.deleteLocalStoreAfterUpload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogLevel": {
                return Optional.ofNullable(clazz.cast(this.logLevelAsString()));
            }
            case "LogFlushLevel": {
                return Optional.ofNullable(clazz.cast(this.logFlushLevelAsString()));
            }
            case "LocalStoreLocation": {
                return Optional.ofNullable(clazz.cast(this.localStoreLocation()));
            }
            case "LocalStoreFileRotationMaxFiles": {
                return Optional.ofNullable(clazz.cast(this.localStoreFileRotationMaxFiles()));
            }
            case "LocalStoreFileRotationMaxBytes": {
                return Optional.ofNullable(clazz.cast(this.localStoreFileRotationMaxBytes()));
            }
            case "UploadLog": {
                return Optional.ofNullable(clazz.cast(this.uploadLog()));
            }
            case "UploadPeriodMinutes": {
                return Optional.ofNullable(clazz.cast(this.uploadPeriodMinutes()));
            }
            case "DeleteLocalStoreAfterUpload": {
                return Optional.ofNullable(clazz.cast(this.deleteLocalStoreAfterUpload()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("LogLevel", LOG_LEVEL_FIELD);
        map.put("LogFlushLevel", LOG_FLUSH_LEVEL_FIELD);
        map.put("LocalStoreLocation", LOCAL_STORE_LOCATION_FIELD);
        map.put("LocalStoreFileRotationMaxFiles", LOCAL_STORE_FILE_ROTATION_MAX_FILES_FIELD);
        map.put("LocalStoreFileRotationMaxBytes", LOCAL_STORE_FILE_ROTATION_MAX_BYTES_FIELD);
        map.put("UploadLog", UPLOAD_LOG_FIELD);
        map.put("UploadPeriodMinutes", UPLOAD_PERIOD_MINUTES_FIELD);
        map.put("DeleteLocalStoreAfterUpload", DELETE_LOCAL_STORE_AFTER_UPLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuntimeLogConfigurations, T> g) {
        return obj -> g.apply((RuntimeLogConfigurations)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logLevel;
        private String logFlushLevel;
        private String localStoreLocation;
        private Integer localStoreFileRotationMaxFiles;
        private Integer localStoreFileRotationMaxBytes;
        private Boolean uploadLog;
        private Integer uploadPeriodMinutes;
        private Boolean deleteLocalStoreAfterUpload;

        private BuilderImpl() {
        }

        private BuilderImpl(RuntimeLogConfigurations model) {
            this.logLevel(model.logLevel);
            this.logFlushLevel(model.logFlushLevel);
            this.localStoreLocation(model.localStoreLocation);
            this.localStoreFileRotationMaxFiles(model.localStoreFileRotationMaxFiles);
            this.localStoreFileRotationMaxBytes(model.localStoreFileRotationMaxBytes);
            this.uploadLog(model.uploadLog);
            this.uploadPeriodMinutes(model.uploadPeriodMinutes);
            this.deleteLocalStoreAfterUpload(model.deleteLocalStoreAfterUpload);
        }

        public final String getLogLevel() {
            return this.logLevel;
        }

        public final void setLogLevel(String logLevel) {
            this.logLevel = logLevel;
        }

        @Override
        public final Builder logLevel(String logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Override
        public final Builder logLevel(LogLevel logLevel) {
            this.logLevel(logLevel == null ? null : logLevel.toString());
            return this;
        }

        public final String getLogFlushLevel() {
            return this.logFlushLevel;
        }

        public final void setLogFlushLevel(String logFlushLevel) {
            this.logFlushLevel = logFlushLevel;
        }

        @Override
        public final Builder logFlushLevel(String logFlushLevel) {
            this.logFlushLevel = logFlushLevel;
            return this;
        }

        @Override
        public final Builder logFlushLevel(LogLevel logFlushLevel) {
            this.logFlushLevel(logFlushLevel == null ? null : logFlushLevel.toString());
            return this;
        }

        public final String getLocalStoreLocation() {
            return this.localStoreLocation;
        }

        public final void setLocalStoreLocation(String localStoreLocation) {
            this.localStoreLocation = localStoreLocation;
        }

        @Override
        public final Builder localStoreLocation(String localStoreLocation) {
            this.localStoreLocation = localStoreLocation;
            return this;
        }

        public final Integer getLocalStoreFileRotationMaxFiles() {
            return this.localStoreFileRotationMaxFiles;
        }

        public final void setLocalStoreFileRotationMaxFiles(Integer localStoreFileRotationMaxFiles) {
            this.localStoreFileRotationMaxFiles = localStoreFileRotationMaxFiles;
        }

        @Override
        public final Builder localStoreFileRotationMaxFiles(Integer localStoreFileRotationMaxFiles) {
            this.localStoreFileRotationMaxFiles = localStoreFileRotationMaxFiles;
            return this;
        }

        public final Integer getLocalStoreFileRotationMaxBytes() {
            return this.localStoreFileRotationMaxBytes;
        }

        public final void setLocalStoreFileRotationMaxBytes(Integer localStoreFileRotationMaxBytes) {
            this.localStoreFileRotationMaxBytes = localStoreFileRotationMaxBytes;
        }

        @Override
        public final Builder localStoreFileRotationMaxBytes(Integer localStoreFileRotationMaxBytes) {
            this.localStoreFileRotationMaxBytes = localStoreFileRotationMaxBytes;
            return this;
        }

        public final Boolean getUploadLog() {
            return this.uploadLog;
        }

        public final void setUploadLog(Boolean uploadLog) {
            this.uploadLog = uploadLog;
        }

        @Override
        public final Builder uploadLog(Boolean uploadLog) {
            this.uploadLog = uploadLog;
            return this;
        }

        public final Integer getUploadPeriodMinutes() {
            return this.uploadPeriodMinutes;
        }

        public final void setUploadPeriodMinutes(Integer uploadPeriodMinutes) {
            this.uploadPeriodMinutes = uploadPeriodMinutes;
        }

        @Override
        public final Builder uploadPeriodMinutes(Integer uploadPeriodMinutes) {
            this.uploadPeriodMinutes = uploadPeriodMinutes;
            return this;
        }

        public final Boolean getDeleteLocalStoreAfterUpload() {
            return this.deleteLocalStoreAfterUpload;
        }

        public final void setDeleteLocalStoreAfterUpload(Boolean deleteLocalStoreAfterUpload) {
            this.deleteLocalStoreAfterUpload = deleteLocalStoreAfterUpload;
        }

        @Override
        public final Builder deleteLocalStoreAfterUpload(Boolean deleteLocalStoreAfterUpload) {
            this.deleteLocalStoreAfterUpload = deleteLocalStoreAfterUpload;
            return this;
        }

        public RuntimeLogConfigurations build() {
            return new RuntimeLogConfigurations(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuntimeLogConfigurations> {
        public Builder logLevel(String var1);

        public Builder logLevel(LogLevel var1);

        public Builder logFlushLevel(String var1);

        public Builder logFlushLevel(LogLevel var1);

        public Builder localStoreLocation(String var1);

        public Builder localStoreFileRotationMaxFiles(Integer var1);

        public Builder localStoreFileRotationMaxBytes(Integer var1);

        public Builder uploadLog(Boolean var1);

        public Builder uploadPeriodMinutes(Integer var1);

        public Builder deleteLocalStoreAfterUpload(Boolean var1);
    }
}

