/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListManagedThingAccountAssociationsResponse;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ManagedThingAssociation;

public class ListManagedThingAccountAssociationsPublisher
implements SdkPublisher<ListManagedThingAccountAssociationsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListManagedThingAccountAssociationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListManagedThingAccountAssociationsPublisher(IotManagedIntegrationsAsyncClient client, ListManagedThingAccountAssociationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListManagedThingAccountAssociationsPublisher(IotManagedIntegrationsAsyncClient client, ListManagedThingAccountAssociationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListManagedThingAccountAssociationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListManagedThingAccountAssociationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ManagedThingAssociation> items() {
        Function<ListManagedThingAccountAssociationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListManagedThingAccountAssociationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListManagedThingAccountAssociationsResponseFetcher
    implements AsyncPageFetcher<ListManagedThingAccountAssociationsResponse> {
        private ListManagedThingAccountAssociationsResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedThingAccountAssociationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListManagedThingAccountAssociationsResponse> nextPage(ListManagedThingAccountAssociationsResponse previousPage) {
            if (previousPage == null) {
                return ListManagedThingAccountAssociationsPublisher.this.client.listManagedThingAccountAssociations(ListManagedThingAccountAssociationsPublisher.this.firstRequest);
            }
            return ListManagedThingAccountAssociationsPublisher.this.client.listManagedThingAccountAssociations((ListManagedThingAccountAssociationsRequest)((Object)ListManagedThingAccountAssociationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

