/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.iotmanagedintegrations.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.IotManagedIntegrationsAsyncClient;
import software.amazon.awssdk.services.iotmanagedintegrations.internal.UserAgentUtils;
import software.amazon.awssdk.services.iotmanagedintegrations.model.EventLogConfigurationSummary;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsRequest;
import software.amazon.awssdk.services.iotmanagedintegrations.model.ListEventLogConfigurationsResponse;

public class ListEventLogConfigurationsPublisher
implements SdkPublisher<ListEventLogConfigurationsResponse> {
    private final IotManagedIntegrationsAsyncClient client;
    private final ListEventLogConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEventLogConfigurationsPublisher(IotManagedIntegrationsAsyncClient client, ListEventLogConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEventLogConfigurationsPublisher(IotManagedIntegrationsAsyncClient client, ListEventLogConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEventLogConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEventLogConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EventLogConfigurationSummary> eventLogConfigurationList() {
        Function<ListEventLogConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.eventLogConfigurationList() != null) {
                return response.eventLogConfigurationList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEventLogConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEventLogConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListEventLogConfigurationsResponse> {
        private ListEventLogConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListEventLogConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEventLogConfigurationsResponse> nextPage(ListEventLogConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListEventLogConfigurationsPublisher.this.client.listEventLogConfigurations(ListEventLogConfigurationsPublisher.this.firstRequest);
            }
            return ListEventLogConfigurationsPublisher.this.client.listEventLogConfigurations((ListEventLogConfigurationsRequest)((Object)ListEventLogConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

